/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.customer.CustomerQueryImpl;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.customer.CustomerQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerQueryImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testQueryById() {
        Customer customer = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        CustomerQuery query = (CustomerQuery)this.getQuery().id(customer.getId());
        this.checkQuery(query, customer);
        Assert.assertEquals((Object)customer, (Object)query.findFirst());
    }

    @Test
    public void testQueryByName() {
        String name = ValueStrategy.randomString();
        Customer customerA = this.createCustomer(name);
        Customer customerB = this.createCustomer(name);
        CustomerQuery query = (CustomerQuery)this.getQuery().name(name);
        this.checkQuery(query, customerA, customerB);
    }

    @Test
    public void testQueryByNameFilter() {
        String name = ValueStrategy.randomString();
        Customer customerA = this.createCustomer(name + "A");
        Customer customerB = this.createCustomer(name + "B");
        CustomerQuery query1 = this.getQuery().name(Filter.like((String)(name + "%")));
        this.checkQuery(query1, customerA, customerB);
    }

    @Test
    public void testQueryByActiveInactive() {
        String name = ValueStrategy.randomString();
        Customer customerA = this.createCustomer(name + "A", true);
        Customer customerB = this.createCustomer(name + "B", false);
        Customer customerC = this.createCustomer(name + "C", true);
        CustomerQuery query1 = this.getQuery().name(Filter.like((String)(name + "%")));
        this.checkQuery(query1, customerA, customerB, customerC);
        CustomerQuery query2 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).active();
        this.checkQuery(query2, customerA, customerC);
        CustomerQuery query3 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).inactive();
        this.checkQuery(query3, customerB);
    }

    @Test
    public void testOrderById() {
        String name = ValueStrategy.randomString();
        Customer customerA = this.createCustomer(name + "A", true);
        Customer customerB = this.createCustomer(name + "B", false);
        Customer customerC = this.createCustomer(name + "C", true);
        CustomerQuery query1 = this.getQuery().name(Filter.like((String)(name + "%")));
        this.checkQuery(query1, customerA, customerB, customerC);
        CustomerQuery query2 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderById();
        this.checkQuery(query2, customerA, customerB, customerC);
        CustomerQuery query3 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderById(true);
        this.checkQuery(query3, customerA, customerB, customerC);
        CustomerQuery query4 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderById(false);
        this.checkQuery(query4, customerC, customerB, customerA);
    }

    @Test
    public void testOrderByName() {
        String name = ValueStrategy.randomString();
        Customer customerA = this.createCustomer(name + "Z");
        Customer customerB = this.createCustomer(name + "A");
        Customer customerC = this.createCustomer(name + "A");
        Assert.assertTrue((customerB.getId() < customerC.getId() ? 1 : 0) != 0);
        CustomerQuery query1 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderByName();
        this.checkQuery(query1, customerB, customerC, customerA);
        CustomerQuery query2 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderByName(true);
        this.checkQuery(query2, customerB, customerC, customerA);
        CustomerQuery query3 = (CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderByName(false);
        this.checkQuery(query3, customerA, customerB, customerC);
        CustomerQuery query4 = (CustomerQuery)((CustomerQuery)this.getQuery().name(Filter.like((String)(name + "%"))).orderByName(true)).orderById(false);
        this.checkQuery(query4, customerC, customerB, customerA);
    }

    @Test
    public void testQueryByLastFirstName() {
        String suffix = ValueStrategy.randomString();
        String lastNameA = "Smith" + suffix;
        String lastNameB = "Smyth" + suffix;
        String lastNameC = "Smithers" + suffix;
        Customer customerA = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Jo", lastNameA), Customer.class);
        Customer customerB = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Jo", lastNameB), Customer.class);
        Customer customerC = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Joanna", lastNameC), Customer.class);
        CustomerQuery query1 = (CustomerQuery)this.getQuery().name(lastNameA);
        this.checkQuery(query1, customerA);
        CustomerQuery query2 = this.getQuery().name(lastNameA, "Jo");
        this.checkQuery(query2, customerA);
        CustomerQuery query3 = this.getQuery().name(lastNameA, "Joanna");
        this.checkQuery(query3, new Customer[0]);
        CustomerQuery query4 = this.getQuery().name(Filter.equal((Object)lastNameA));
        this.checkQuery(query4, customerA);
        CustomerQuery query5 = this.getQuery().name(Filter.equal((Object)lastNameB), Filter.equal((Object)"Jo"));
        this.checkQuery(query5, customerB);
        CustomerQuery query6 = (CustomerQuery)this.getQuery().name(lastNameA);
        this.checkQuery(query6, customerA);
        CustomerQuery query7 = this.getQuery().name(Filter.like((String)("Smith%" + suffix)));
        this.checkQuery(query7, customerA, customerC);
        CustomerQuery query8 = this.getQuery().name(Filter.like((String)("S%" + suffix)), Filter.like((String)"Joan%"));
        this.checkQuery(query8, customerC);
        CustomerQuery query9 = this.getQuery().name(Filter.like((String)("S%" + suffix)), Filter.like((String)"J%"));
        this.checkQuery(query9, customerA, customerB, customerC);
    }

    @Test
    public void testQueryByAddress() {
        String name = ValueStrategy.randomString();
        Lookup suburb1 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup suburb2 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup vic = this.lookupFactory.getLookup("lookup.state", "VIC", "Victoria");
        Lookup nsw = this.lookupFactory.getLookup("lookup.state", "NSW", "New South Wales");
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().lastName(name).addAddress("1024 Broadwater Avenue", suburb1.getCode(), vic.getCode(), "3925", new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().lastName(name).addAddress("1024 Broadwater St", suburb1.getCode(), vic.getCode(), "3925", new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().lastName(name).addAddress("1024 Broadwater St", suburb2.getCode(), nsw.getCode(), "2360", new String[0])).build(), Customer.class);
        CustomerQuery query1 = ((CustomerQuery)this.getQuery().name(name)).address("1024 Broadwater Avenue", suburb1.getName(), "3925", vic.getName());
        this.checkQuery(query1, customerA);
        CustomerQuery query2 = ((CustomerQuery)this.getQuery().name(name)).address("1024 Broadwater St", null, null, null);
        this.checkQuery(query2, customerB, customerC);
        CustomerQuery query3 = ((CustomerQuery)this.getQuery().name(name)).address(null, suburb1.getName(), null, null);
        this.checkQuery(query3, customerA, customerB);
        CustomerQuery query4 = ((CustomerQuery)this.getQuery().name(name)).address(null, null, "3925", null);
        this.checkQuery(query4, customerA, customerB);
        CustomerQuery query5 = ((CustomerQuery)this.getQuery().name(name)).address(null, null, null, vic.getName());
        this.checkQuery(query5, customerA, customerB);
        CustomerQuery query6 = ((CustomerQuery)this.getQuery().name(name)).address(Filter.like((String)"1024 Broadwater%"), null, null, null);
        this.checkQuery(query6, customerA, customerB, customerC);
        CustomerQuery query7 = ((CustomerQuery)this.getQuery().name(name)).address(null, Filter.like((String)(suburb1.getName() + "%")), null, null);
        this.checkQuery(query7, customerA, customerB);
        CustomerQuery query9 = ((CustomerQuery)this.getQuery().name(name)).address(null, null, Filter.like((String)"236%"), null);
        this.checkQuery(query9, customerC);
        CustomerQuery query10 = ((CustomerQuery)this.getQuery().name(name)).address(null, null, null, Filter.like((String)"Vic%"));
        this.checkQuery(query10, customerA, customerB);
    }

    @Test
    public void testQueryByEmail() {
        String prefix = ValueStrategy.randomString();
        String emailA = prefix + "A@gmail.com";
        String emailB = prefix + "B@gmail.com";
        String emailC = prefix + "C@gmail.com";
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailA, new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailB, new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailC, new String[0])).build(), Customer.class);
        CustomerQuery query1 = this.getQuery().email(emailA);
        this.checkQuery(query1, customerA);
        CustomerQuery query2 = this.getQuery().email(Filter.equal((Object)emailB));
        this.checkQuery(query2, customerB);
        CustomerQuery query3 = this.getQuery().email(Filter.like((String)(prefix + "%")));
        this.checkQuery(query3, customerA, customerB, customerC);
    }

    @Test
    public void testQueryByPhone() {
        String prefix = ValueStrategy.randomString();
        String phoneA = prefix + "1";
        String phoneB = prefix + "2";
        String phoneC = prefix + "3";
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneA, new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneB, new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneC, new String[0])).build(), Customer.class);
        CustomerQuery query1 = this.getQuery().phone(phoneA);
        this.checkQuery(query1, customerA);
        CustomerQuery query2 = this.getQuery().phone(Filter.equal((Object)phoneB));
        this.checkQuery(query2, customerB);
        CustomerQuery query3 = this.getQuery().phone(Filter.like((String)(prefix + "%")));
        this.checkQuery(query3, customerA, customerB, customerC);
    }

    private CustomerQueryImpl getQuery() {
        return new CustomerQueryImpl((ArchetypeService)this.getArchetypeService(), this.domainService);
    }

    private void checkQuery(CustomerQuery query, Customer ... expected) {
        List matches = IterableUtils.toList((Iterable)query.query());
        Assert.assertEquals(Arrays.asList(expected), (Object)matches);
    }

    private Customer createCustomer(String name) {
        Party customer = this.customerFactory.createCustomer("Jo", name);
        return (Customer)this.domainService.create((IMObject)customer, Customer.class);
    }

    private Customer createCustomer(String lastName, boolean active) {
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().firstName("Jo").lastName(lastName).active(active)).build();
        return (Customer)this.domainService.create((IMObject)customer, Customer.class);
    }
}

