/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.factory;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.DocumentBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.CustomerPatients;
import org.openvpms.domain.internal.customer.CustomerImpl;
import org.openvpms.domain.internal.customer.CustomerPatientsImpl;
import org.openvpms.domain.internal.factory.DomainServiceImpl;
import org.openvpms.domain.internal.object.RelatedDomainObjects;
import org.openvpms.domain.internal.patient.record.DefaultRecordImpl;
import org.openvpms.domain.internal.patient.record.DocumentRecordDocumentBuilderImpl;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Record;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DomainServiceImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;

    @Test
    public void testCreate() {
        DomainServiceImpl domainService = this.getDomainService();
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        Customer customer1 = (Customer)domainService.create((IMObject)party, Customer.class);
        Assert.assertTrue((boolean)(customer1 instanceof CustomerImpl));
        IMObjectBean bean = this.getBean((IMObject)party);
        Customer customer2 = (Customer)domainService.create(bean, Customer.class);
        Assert.assertTrue((boolean)(customer2 instanceof CustomerImpl));
    }

    @Test
    public void testCreateWithFallback() {
        DomainServiceImpl domainService = this.getDomainService();
        Act act = (Act)this.create("act.patientClinicalAddendum", Act.class);
        try {
            domainService.create((IMObject)act, Record.class);
            Assert.fail((String)"Expected create to fail");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"No conversion from act.patientClinicalAddendum to org.openvpms.domain.patient.record.Record", (Object)exception.getMessage());
        }
        Record record = (Record)domainService.create((IMObject)act, Record.class, DefaultRecordImpl.class);
        Assert.assertTrue((boolean)(record instanceof DefaultRecordImpl));
    }

    @Test
    public void testBean() {
        DomainServiceImpl domainService = this.getDomainService();
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        IMObjectBean bean = domainService.getBean((IMObject)party);
        bean.save();
        Assert.assertNotNull((Object)this.get((IMObject)party));
    }

    @Test
    public void testCreateBuilder() {
        DomainServiceImpl domainService = this.getDomainService();
        DocumentAct act = this.patientFactory.newInvestigation().build(false);
        DocumentBuilder builder = (DocumentBuilder)domainService.createBuilder((IMObject)act, DocumentRecordDocumentBuilderImpl.class);
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testCreateRelated() {
        ArrayList conflictingBean1 = new ArrayList();
        ArrayList conflictingBean2 = new ArrayList();
        DomainServiceImpl domainService = this.createDomainServiceWithConflictingBeans("conflictingBean1", conflictingBean1, "conflictingBean2", conflictingBean2);
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        ArrayList relationships = new ArrayList(patient.getTargetEntityRelationships());
        CustomerPatients related = (CustomerPatients)domainService.createRelated(relationships, CustomerPatientsImpl.class);
        Assert.assertNotNull((Object)related);
        List actual = related.getRelationships();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals(relationships.get(0), actual.get(0));
        try {
            this.applicationContext.getBean("conflictingBean1");
            Assert.fail((String)"Parent context should not have test bean definition");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRelatedObjects() {
        ArrayList conflictingBean1 = new ArrayList();
        ArrayList conflictingBean2 = new ArrayList();
        DomainServiceImpl domainService = this.createDomainServiceWithConflictingBeans("conflictingBean1", conflictingBean1, "conflictingBean2", conflictingBean2);
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        ArrayList relationships = new ArrayList(patient.getTargetEntityRelationships());
        RelatedDomainObjects related = domainService.createRelatedObjects(relationships, Patient.class);
        Assert.assertNotNull((Object)related);
        List actual = related.getRelationships();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals(relationships.get(0), actual.get(0));
        Patient object = (Patient)related.getObject();
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((long)patient.getId(), (long)object.getId());
    }

    @Test
    public void testCreateRelatedObjectsWithFallback() {
        DomainServiceImpl domainService = this.getDomainService();
        ArrayList relationships = new ArrayList();
        RelatedDomainObjects related = domainService.createRelatedObjects(relationships, Record.class, DefaultRecordImpl.class);
        Assert.assertNotNull((Object)related);
    }

    @Test
    public void testGet() {
        DomainServiceImpl domainService = this.getDomainService();
        Party active = this.customerFactory.createCustomer();
        Party inactive = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().active(false)).build();
        Assert.assertTrue((boolean)(domainService.get(active.getObjectReference(), Customer.class) instanceof CustomerImpl));
        Assert.assertTrue((boolean)(domainService.get(active.getObjectReference(), Customer.class, true) instanceof CustomerImpl));
        Assert.assertNull((Object)domainService.get(active.getObjectReference(), Customer.class, false));
        Assert.assertTrue((boolean)(domainService.get(active.getArchetype(), active.getId(), Customer.class) instanceof CustomerImpl));
        Assert.assertTrue((boolean)(domainService.get(active.getArchetype(), active.getId(), Customer.class, true) instanceof CustomerImpl));
        Assert.assertNull((Object)domainService.get(active.getArchetype(), active.getId(), Customer.class, false));
        Assert.assertTrue((boolean)(domainService.get(inactive.getObjectReference(), Customer.class) instanceof CustomerImpl));
        Assert.assertNull((Object)domainService.get(inactive.getObjectReference(), Customer.class, true));
        Assert.assertTrue((boolean)(domainService.get(inactive.getObjectReference(), Customer.class, false) instanceof CustomerImpl));
        Assert.assertTrue((boolean)(domainService.get(inactive.getArchetype(), inactive.getId(), Customer.class) instanceof CustomerImpl));
        Assert.assertNull((Object)domainService.get(inactive.getArchetype(), inactive.getId(), Customer.class, true));
        Assert.assertTrue((boolean)(domainService.get(inactive.getArchetype(), inactive.getId(), Customer.class, false) instanceof CustomerImpl));
    }

    @Test
    public void testCreateWithNoConversion() {
        DomainServiceImpl domainService = this.getDomainService();
        Entity test = this.laboratoryFactory.createHL7Test(this.laboratoryFactory.createInvestigationType());
        try {
            domainService.create((IMObject)test, org.openvpms.domain.laboratory.Test.class);
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"No conversion from entity.laboratoryTestHL7 to org.openvpms.domain.laboratory.Test", (Object)exception.getMessage());
        }
        try {
            domainService.create(this.getBean((IMObject)test), org.openvpms.domain.laboratory.Test.class);
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"No conversion from entity.laboratoryTestHL7 to org.openvpms.domain.laboratory.Test", (Object)exception.getMessage());
        }
    }

    @Test
    public void testGetWithNoConversion() {
        DomainServiceImpl domainService = this.getDomainService();
        Entity test = this.laboratoryFactory.createHL7Test(this.laboratoryFactory.createInvestigationType());
        try {
            domainService.get(test.getObjectReference(), org.openvpms.domain.laboratory.Test.class);
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"No conversion from entity.laboratoryTestHL7 to org.openvpms.domain.laboratory.Test", (Object)exception.getMessage());
        }
    }

    private DomainServiceImpl createDomainServiceWithConflictingBeans(String bean1Name, Object bean1, String bean2Name, Object bean2) {
        GenericApplicationContext testApplicationContext = new GenericApplicationContext(this.applicationContext);
        ConfigurableListableBeanFactory beanFactory = testApplicationContext.getBeanFactory();
        beanFactory.registerSingleton(bean1Name, bean1);
        beanFactory.registerSingleton(bean2Name, bean2);
        testApplicationContext.refresh();
        Assert.assertNotNull((Object)testApplicationContext.getBean(bean1Name));
        Assert.assertNotNull((Object)testApplicationContext.getBean(bean2Name));
        return this.getDomainService((ApplicationContext)testApplicationContext);
    }

    private DomainServiceImpl getDomainService() {
        return this.getDomainService(this.applicationContext);
    }

    private DomainServiceImpl getDomainService(ApplicationContext context) {
        DomainServiceImpl result = new DomainServiceImpl((ArchetypeService)this.getArchetypeService());
        result.setApplicationContext(context);
        return result;
    }
}

