/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.user;

import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.domain.im.security.BeanUserDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.user.Employee;

public class EmployeeImpl
extends BeanUserDecorator
implements Employee {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    private final UserRules userRules;

    public EmployeeImpl(User peer, ArchetypeService service, UserRules userRules) {
        super(peer, (IMObjectBeanFactory)service);
        this.userRules = userRules;
    }

    public EmployeeImpl(IMObjectBean bean, UserRules userRules) {
        super(bean);
        this.userRules = userRules;
    }

    public String getTitle() {
        Lookup title = this.getBean().getLookup("title");
        return title != null ? title.getName() : null;
    }

    public String getFirstName() {
        return this.getBean().getString(FIRST_NAME);
    }

    public String getLastName() {
        return this.getBean().getString(LAST_NAME);
    }

    public String getQualifications() {
        return this.getBean().getString("qualifications");
    }

    public boolean isClinician() {
        return this.userRules.isClinician((User)this);
    }

    public static boolean isEmployee(IMObjectBean bean) {
        return bean.getString(FIRST_NAME) != null && bean.getString(LAST_NAME) != null;
    }
}

