/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.sync;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.domain.internal.sync.Change;
import org.openvpms.domain.sync.Changes;

public class DefaultChanges<T>
implements Changes<T> {
    private final Set<T> added = new LinkedHashSet<T>();
    private final Set<T> updated = new LinkedHashSet<T>();
    private final Set<T> deactivated = new LinkedHashSet<T>();

    public Changes<T> added(T object) {
        this.added.add(object);
        return this;
    }

    public Changes<T> updated(T object) {
        this.updated.add(object);
        return this;
    }

    public Changes<T> deactivated(T object) {
        this.deactivated.add(object);
        return this;
    }

    public List<T> getAdded() {
        return new ArrayList<T>(this.added);
    }

    public List<T> getUpdated() {
        return new ArrayList<T>(this.updated);
    }

    public List<T> getDeactivated() {
        return new ArrayList<T>(this.deactivated);
    }

    public List<Change<T>> getChanges() {
        ArrayList<Change<T>> result = new ArrayList<Change<T>>();
        for (T object : this.getAdded()) {
            result.add(new DefaultChange<T>(object, Change.Type.ADDED));
        }
        for (T object : this.getUpdated()) {
            result.add(new DefaultChange<T>(object, Change.Type.UPDATED));
        }
        for (T object : this.getDeactivated()) {
            result.add(new DefaultChange<T>(object, Change.Type.DEACTIVATED));
        }
        return result;
    }

    private static class DefaultChange<T>
    implements Change<T> {
        private final T object;
        private final Change.Type type;

        DefaultChange(T object, Change.Type type) {
            this.object = object;
            this.type = type;
        }

        @Override
        public T getObject() {
            return this.object;
        }

        @Override
        public Change.Type getType() {
            return this.type;
        }
    }
}

