/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.user;

import javax.persistence.criteria.Expression;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.user.UserFactory;
import org.openvpms.domain.internal.service.user.UserQueryImpl;
import org.openvpms.domain.service.user.UserQuery;
import org.openvpms.domain.service.user.Users;

public class UsersImpl
implements Users {
    private final ArchetypeService service;
    private final DomainService domainService;

    public UsersImpl(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public User getUser(long id) {
        User user = (User)this.service.get("security.user", id, User.class);
        return user != null ? UserFactory.create(user, this.domainService) : null;
    }

    public User getUser(String username) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(User.class);
        Root from = query.from(User.class, new String[]{"security.user"});
        query.where((Expression)builder.equal((Expression)from.get("username"), (Object)username));
        User user = (User)this.service.createQuery(query).getFirstResult();
        return user != null ? UserFactory.create(user, this.domainService) : null;
    }

    public UserQuery getQuery() {
        return new UserQueryImpl(this.service, this.domainService);
    }
}

