/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.product;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.domain.internal.query.DomainQueryImpl;
import org.openvpms.domain.internal.service.product.MedicationQueryImpl;
import org.openvpms.domain.internal.service.product.MerchandiseQueryImpl;
import org.openvpms.domain.internal.service.product.ProductQueryState;
import org.openvpms.domain.internal.service.product.ServiceQueryImpl;
import org.openvpms.domain.internal.service.product.TemplateQueryImpl;
import org.openvpms.domain.product.Medication;
import org.openvpms.domain.product.Merchandise;
import org.openvpms.domain.product.Service;
import org.openvpms.domain.product.Template;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.product.AbstractProductQuery;
import org.openvpms.domain.service.product.MedicationQuery;
import org.openvpms.domain.service.product.MerchandiseQuery;
import org.openvpms.domain.service.product.ServiceQuery;
import org.openvpms.domain.service.product.TemplateQuery;

public abstract class AbstractProductQueryImpl<D extends Product, Q extends AbstractProductQuery<D, Q>>
extends DomainQueryImpl<D, Product, Q>
implements AbstractProductQuery<D, Q> {
    protected AbstractProductQueryImpl(ProductQueryState<D> state) {
        super(state);
    }

    public Q productType(String name) {
        ((ProductQueryState)this.getState()).setProductTypeName((Filter<String>)Filter.equal((Object)name));
        return (Q)((AbstractProductQuery)this.getThis());
    }

    public MedicationQuery medications() {
        return new MedicationQueryImpl((ProductQueryState<Medication>)((ProductQueryState)this.getState()).newState(Medication.class));
    }

    public MerchandiseQuery merchandise() {
        return new MerchandiseQueryImpl((ProductQueryState<Merchandise>)((ProductQueryState)this.getState()).newState(Merchandise.class));
    }

    public ServiceQuery services() {
        return new ServiceQueryImpl((ProductQueryState<Service>)((ProductQueryState)this.getState()).newState(Service.class));
    }

    public TemplateQuery templates() {
        return new TemplateQueryImpl((ProductQueryState<Template>)((ProductQueryState)this.getState()).newState(Template.class));
    }

    protected ProductQueryState<D> getState() {
        return (ProductQueryState)super.getState();
    }

    @Override
    protected TypedQuery<Product> createQuery() {
        List<String> archetypes = this.getState().getArchetypes();
        if (archetypes == null || archetypes.isEmpty()) {
            this.archetypes("product.medication", "product.merchandise", "product.service", "product.template");
        }
        return super.createQuery();
    }

    @Override
    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<Product> query, Root<Product> from, CriteriaBuilder builder) {
        this.addProductTypeFilters(from, builder);
        super.addPredicates(predicates, query, from, builder);
    }

    private void addProductTypeFilters(Root<Product> from, CriteriaBuilder builder) {
        Filter<Long> productTypeId = ((ProductQueryState)this.getState()).getProductTypeId();
        Filter<String> productTypeName = ((ProductQueryState)this.getState()).getProductTypeName();
        if (productTypeId != null || productTypeName != null) {
            Join join = from.join("type").join("target");
            ArrayList<Predicate> joinPredicates = new ArrayList<Predicate>();
            if (productTypeId != null) {
                joinPredicates.add(this.createPredicate(join.get("id"), productTypeId, builder));
            }
            if (productTypeName != null) {
                joinPredicates.add(this.createPredicate(join.get("name"), productTypeName, builder));
            }
            join.on(joinPredicates.toArray(new Predicate[0]));
        }
    }
}

