/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.patient.record.builder.VisitBuilderImpl;
import org.openvpms.domain.internal.query.IdQuery;
import org.openvpms.domain.internal.service.patient.PatientBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientQueryImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Record;
import org.openvpms.domain.patient.record.Visit;
import org.openvpms.domain.patient.record.builder.VisitBuilder;
import org.openvpms.domain.service.patient.PatientBuilder;
import org.openvpms.domain.service.patient.PatientQuery;
import org.openvpms.domain.service.patient.Patients;

public class PatientsImpl
implements Patients {
    private final PatientServices services;
    private final IdQuery query;

    public PatientsImpl(PatientServices services) {
        this.services = services;
        this.query = new IdQuery(services.getArchetypeService());
    }

    public Patient getPatient(long id) {
        return (Patient)this.services.getDomainService().get("party.patientpet", id, Patient.class);
    }

    public PatientQuery getQuery() {
        return new PatientQueryImpl(this.services.getArchetypeService(), this.services.getDomainService());
    }

    public PatientBuilder getPatientBuilder() {
        return new PatientBuilderImpl(this.services);
    }

    public PatientBuilder getPatientBuilder(Patient patient) {
        return new PatientBuilderImpl((Party)patient, this.services);
    }

    public VisitBuilder getVisitBuilder() {
        return new VisitBuilderImpl(this.services);
    }

    public VisitBuilder getVisitBuilder(Visit visit) {
        return new VisitBuilderImpl(visit, this.services);
    }

    public Record getRecord(String archetype, String idArchetype, String identity) {
        Act act = this.query.getObject(archetype, Act.class, idArchetype, identity);
        return act != null ? this.services.getDomainService().create(act, Record.class) : null;
    }

    public boolean exists(String archetype, String idArchetype, String identity) {
        return this.query.exists(archetype, Act.class, idArchetype, identity);
    }
}

