/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.business.domain.im.common.Beanable;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.builder.DomainObjectBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.builder.TargetNodeValue;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.service.customer.CustomerBuilder;

public class CustomerBuilderImpl
extends DomainObjectBuilder<Customer, Party, CustomerBuilderImpl>
implements CustomerBuilder {
    private final CustomerRules rules;
    private final LookupService lookups;
    private final Map<String, String> externalIds = new HashMap<String, String>();
    private final NodeValue title = new NodeValue("title");
    private final NodeValue firstName = new NodeValue("firstName");
    private final NodeValue lastName = new NodeValue("lastName");
    private final NodeValue companyName = new NodeValue("companyName");
    private final NodeValue address = new NodeValue("address");
    private final NodeValue suburb = new NodeValue("suburb");
    private final NodeValue postcode = new NodeValue("postcode");
    private final NodeValue state = new NodeValue("state");
    private final NodeValue homePhone = new NodeValue("telephoneNumber");
    private final NodeValue workPhone = new NodeValue("telephoneNumber");
    private final NodeValue mobilePhone = new NodeValue("telephoneNumber");
    private final NodeValue email = new NodeValue("emailAddress");
    private final TargetNodeValue practice = new TargetNodeValue("practice");
    private final NodeValue active = new NodeValue("active");

    public CustomerBuilderImpl(CustomerRules rules, ArchetypeService service, DomainService domainService, LookupService lookups) {
        super("party.customerperson", Party.class, Customer.class, service, domainService);
        this.rules = rules;
        this.lookups = lookups;
    }

    public CustomerBuilderImpl(Party object, CustomerRules rules, ArchetypeService service, DomainService domainService, LookupService lookups) {
        super(object, Customer.class, service, domainService);
        this.rules = rules;
        this.lookups = lookups;
    }

    public CustomerBuilder identity(String archetype, String id) {
        this.externalIds.put(archetype, id);
        return this;
    }

    public CustomerBuilder title(String title) {
        return (CustomerBuilder)this.setValue(this.title, title);
    }

    public CustomerBuilder firstName(String firstName) {
        return (CustomerBuilder)this.setValue(this.firstName, firstName);
    }

    public CustomerBuilder lastName(String lastName) {
        return (CustomerBuilder)this.setValue(this.lastName, lastName);
    }

    public CustomerBuilder companyName(String companyName) {
        return (CustomerBuilder)this.setValue(this.companyName, companyName);
    }

    public CustomerBuilder address(String address, String suburb, String postcode, String state) {
        this.setValue(this.address, address);
        this.setValue(this.suburb, suburb);
        this.setValue(this.postcode, postcode);
        return (CustomerBuilder)this.setValue(this.state, state);
    }

    public CustomerBuilder homePhone(String phone) {
        return (CustomerBuilder)this.setValue(this.homePhone, phone);
    }

    public CustomerBuilder workPhone(String phone) {
        return (CustomerBuilder)this.setValue(this.workPhone, phone);
    }

    public CustomerBuilder mobilePhone(String phone) {
        return (CustomerBuilder)this.setValue(this.mobilePhone, phone);
    }

    public CustomerBuilder email(String email) {
        return (CustomerBuilder)this.setValue(this.email, email);
    }

    public CustomerBuilder practice(Location location) {
        return (CustomerBuilder)this.setValue(this.practice, location);
    }

    public CustomerBuilder active(boolean active) {
        return (CustomerBuilder)this.setValue(this.active, active);
    }

    @Override
    public Customer build(boolean save) {
        return (Customer)super.build(save);
    }

    @Override
    protected boolean build(DomainObjectBuilder.State state) {
        Party object = (Party)state.getObject();
        state.addChanged((IMObject)object);
        if (object instanceof Beanable) {
            object = (Party)((Beanable)object).getObject();
        }
        IMObjectBean bean = state.getBean();
        for (Map.Entry<String, String> entry : this.externalIds.entrySet()) {
            EntityIdentity identity = object.getIdentity(entry.getKey());
            if (identity == null) {
                identity = this.create(entry.getKey(), EntityIdentity.class);
                object.addIdentity(identity);
            }
            identity.setIdentity(entry.getValue());
        }
        this.externalIds.clear();
        this.update(bean, this.title, this.firstName, this.lastName);
        Customer customer = (Customer)state.getDomainObject();
        this.updateAddress(customer);
        if (this.homePhone.isSet() || this.workPhone.isSet() || this.mobilePhone.isSet()) {
            HashMap<String, Contact> inuse = new HashMap<String, Contact>();
            HashSet<Contact> toRemove = new HashSet<Contact>();
            this.updatePhone(object, this.homePhone, "HOME", inuse, toRemove);
            this.updatePhone(object, this.workPhone, "WORK", inuse, toRemove);
            this.updatePhone(object, this.mobilePhone, "MOBILE", inuse, toRemove);
            toRemove.removeAll(inuse.values());
            toRemove.forEach(arg_0 -> ((Party)object).removeContact(arg_0));
        }
        this.updateEmail(customer);
        this.update(bean, this.practice, this.active);
        return true;
    }

    private void updateEmail(Customer customer) {
        if (this.email.isSet()) {
            Email contact = customer.getEmail();
            if (this.email.getValue() == null) {
                if (contact != null) {
                    customer.removeContact((Contact)contact);
                }
            } else {
                if (contact == null) {
                    contact = this.create("contact.email", Contact.class);
                    customer.addContact((Contact)contact);
                }
                IMObjectBean bean = this.getBean((IMObject)contact);
                this.email.update(bean);
            }
        }
    }

    private void updatePhone(Party customer, NodeValue value, String purpose, Map<String, Contact> populated, Set<Contact> maybeRemove) {
        if (value.isSet()) {
            Contact contact = this.rules.getTelephoneContact(customer, true, purpose);
            String phone = value.toString();
            if (phone == null) {
                if (contact != null) {
                    maybeRemove.add(contact);
                }
            } else {
                Lookup lookup;
                Contact match = populated.get(phone);
                if (match == null) {
                    if (contact == null) {
                        contact = this.create("contact.phoneNumber", Contact.class);
                        customer.addContact(contact);
                    } else {
                        this.removePurposesExcept(contact, purpose);
                    }
                    IMObjectBean bean = this.getBean((IMObject)contact);
                    value.update(bean);
                    populated.put(phone, contact);
                } else {
                    contact = match;
                }
                if (this.missingPurpose(contact, purpose) && (lookup = this.lookups.getLookup("lookup.contactPurpose", purpose)) != null) {
                    contact.addClassification(lookup);
                }
            }
        }
    }

    private boolean missingPurpose(Contact contact, String purpose) {
        return contact.getClassifications().stream().noneMatch(lookup -> lookup.getArchetype().equals("lookup.contactPurpose") && lookup.getCode().equals(purpose));
    }

    private void removePurposesExcept(Contact contact, String purpose) {
        new HashSet(contact.getClassifications()).stream().filter(l -> l.getArchetype().equals("lookup.contactPurpose") && !l.getCode().equals(purpose)).forEach(arg_0 -> ((Contact)contact).removeClassification(arg_0));
    }

    private void updateAddress(Customer customer) {
        if (this.address.isSet()) {
            Address contact = customer.getAddress();
            if (contact == null) {
                contact = this.create("contact.location", Contact.class);
                customer.addContact((Contact)contact);
            }
            IMObjectBean bean = this.getBean((IMObject)contact);
            this.update(bean, this.address, this.suburb, this.postcode, this.state);
        }
    }
}

