/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.product;

import java.time.OffsetDateTime;
import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.BeanEntityDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.product.Batch;

public class BatchImpl
extends BeanEntityDecorator
implements Batch {
    private final DomainService domainService;

    public BatchImpl(Entity peer, DomainService domainService) {
        super(peer, (IMObjectBeanFactory)domainService);
        this.domainService = domainService;
    }

    public BatchImpl(IMObjectBean bean, DomainService domainService) {
        super(bean);
        this.domainService = domainService;
    }

    public String getBatchNumber() {
        return this.getName();
    }

    public OffsetDateTime getExpiry() {
        OffsetDateTime result = null;
        EntityLink product = (EntityLink)this.getBean().getObject("product", EntityLink.class);
        if (product != null && product.getActiveEndTime() != null) {
            result = DateRules.toOffsetDateTime((Date)product.getActiveEndTime());
        }
        return result;
    }

    public Product getProduct() {
        IMObject product = this.getBean().getTarget("product", Product.class);
        return product != null ? this.domainService.create(this.getBean(), Product.class) : null;
    }
}

