/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.referral;

import java.time.OffsetDateTime;
import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.referral.Referral;
import org.openvpms.domain.supplier.ReferralPractice;
import org.openvpms.domain.supplier.ReferralVet;

public class ReferralImpl
implements Referral {
    private final PeriodRelationship relationship;
    private final IMObjectBean bean;
    private final DomainService domainService;

    public ReferralImpl(PeriodRelationship relationship, DomainService domainService) {
        this.relationship = relationship;
        this.domainService = domainService;
        this.bean = domainService.getBean((IMObject)relationship);
    }

    public ReferralPractice getPractice() {
        ReferralVet vet = this.getVet();
        return vet != null ? vet.getPractice() : null;
    }

    public ReferralVet getVet() {
        return (ReferralVet)this.domainService.get(this.relationship.getTarget(), ReferralVet.class);
    }

    public OffsetDateTime getDate() {
        Date date = this.relationship.getActiveStartTime();
        return date != null ? DateRules.toOffsetDateTime((Date)date) : null;
    }

    public boolean isActive() {
        return this.relationship.isActive(new Date());
    }

    public boolean referredFrom() {
        return this.relationship.isA("entityRelationship.referredFrom");
    }

    public boolean referredTo() {
        return !this.referredFrom();
    }

    public String getReason() {
        return this.bean.getString("reason");
    }
}

