/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.party;

import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.business.domain.im.party.BeanContactDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Contact;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.party.Address;

public class AddressImpl
extends BeanContactDecorator
implements Address {
    private final PartyRules rules;
    private static final String ADDRESS = "address";
    private static final String SUBURB = "suburb";
    private static final String POSTCODE = "postcode";
    private static final String STATE = "state";
    private static final String COUNTRY = "country";

    public AddressImpl(Contact peer, PartyRules rules, DomainService service) {
        super(peer, (IMObjectBeanFactory)service);
        this.rules = rules;
    }

    public String getAddress() {
        return this.getBean().getString(ADDRESS);
    }

    public String getSuburbName() {
        Lookup lookup = this.getSuburbLookup();
        return lookup != null ? lookup.getName() : null;
    }

    public String getSuburbCode() {
        return this.getBean().getString(SUBURB);
    }

    public Lookup getSuburbLookup() {
        return this.getBean().getLookup(SUBURB);
    }

    public String getPostcode() {
        return this.getBean().getString(POSTCODE);
    }

    public String getStateName() {
        Lookup lookup = this.getStateLookup();
        return lookup != null ? lookup.getName() : null;
    }

    public String getStateCode() {
        return this.getBean().getString(STATE);
    }

    public Lookup getStateLookup() {
        return this.getBean().getLookup(STATE);
    }

    public String getCountryName() {
        Lookup lookup = this.getCountryLookup();
        return lookup != null ? lookup.getName() : null;
    }

    public String getCountryCode() {
        Lookup lookup = this.getCountryLookup();
        return lookup != null ? lookup.getCode() : null;
    }

    public Lookup getCountryLookup() {
        IMObjectBean bean = this.getBean();
        Lookup result = bean.hasNode(COUNTRY) ? bean.getLookup(COUNTRY) : this.rules.getDefaultCountry();
        return result;
    }

    public String format(boolean singleLine) {
        return this.rules.formatAddress(this.getPeer(), singleLine);
    }
}

