/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.object;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.iterators.AbstractUntypedIteratorDecorator;
import org.openvpms.component.business.service.archetype.helper.DefaultRelatedObjectPolicyBuilder;
import org.openvpms.component.business.service.archetype.helper.ObjectRelationshipImpl;
import org.openvpms.component.business.service.archetype.helper.RelatedIMObjectsImpl;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.Order;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.RelatedObjectPolicyBuilder;
import org.openvpms.component.model.bean.RelatedObjects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;

public abstract class AbstractRelatedDomainObjects<T, R extends Relationship, P extends RelatedObjects<T, R, P>>
implements RelatedObjects<T, R, P> {
    private final State<T, R> state;
    private final RelatedIMObjectsImpl<IMObject, R> related;

    public AbstractRelatedDomainObjects(List<R> relationships, Class<T> type, boolean source, DomainService domainService, ArchetypeService service) {
        this(relationships, type, null, source, domainService, service);
    }

    public AbstractRelatedDomainObjects(List<R> relationships, Class<T> type, Class<? extends T> fallbackType, boolean source, DomainService domainService, ArchetypeService service) {
        this(new State<T, R>(relationships, type, fallbackType, source, domainService, service), null);
    }

    protected AbstractRelatedDomainObjects(State<T, R> state, Policy<R> policy) {
        this.state = state;
        this.related = new RelatedIMObjectsImpl((Collection)((State)state).relationships, IMObject.class, ((State)state).source, ((State)state).service, policy);
    }

    public P all() {
        return this.policy(null);
    }

    public P active() {
        return this.policy(Policies.active());
    }

    public P active(Date time) {
        return this.policy(Policies.active());
    }

    public RelatedObjectPolicyBuilder<T, R, P> newPolicy() {
        return new DefaultRelatedObjectPolicyBuilder((RelatedObjects)this, Relationship.class);
    }

    public P policy(Policy<R> policy) {
        return (P)(this.related.hasPolicy(policy) ? this : this.newInstance(this.state, policy));
    }

    public T getObject() {
        IMObject object = this.related.getObject();
        return object != null ? (T)this.state.create(object) : null;
    }

    public ObjectRelationship<T, R> getObjectRelationship() {
        ObjectRelationship pair = this.related.getObjectRelationship();
        if (pair != null) {
            T object = this.state.create((IMObject)pair.getObject());
            return new ObjectRelationshipImpl(object, pair.getRelationship());
        }
        return null;
    }

    public Iterable<T> getObjects() {
        Iterable iterable = this.related.getObjects();
        return () -> new LazyObjectIterator(iterable);
    }

    public Iterable<T> getObjects(int firstResult, int maxResults) {
        Iterable iterable = this.related.getObjects(firstResult, maxResults);
        return () -> new LazyObjectIterator(iterable);
    }

    public Iterable<T> getObjects(int firstResult, int maxResults, Order ... order) {
        Iterable iterable = this.related.getObjects(firstResult, maxResults, order);
        return () -> new LazyObjectIterator(iterable);
    }

    public Iterable<ObjectRelationship<T, R>> getObjectRelationships() {
        Iterable iterable = this.related.getObjectRelationships();
        return () -> new LazyObjectRelationshipIterator(iterable);
    }

    public Iterable<ObjectRelationship<T, R>> getObjectRelationships(int firstResult, int maxResults) {
        Iterable iterable = this.related.getObjectRelationships(firstResult, maxResults);
        return () -> new LazyObjectRelationshipIterator(iterable);
    }

    public List<R> getRelationships() {
        return this.related.getRelationships();
    }

    public List<Reference> getReferences() {
        return this.related.getReferences();
    }

    public Policy<R> getPolicy() {
        return this.related.getPolicy();
    }

    protected abstract P newInstance(State<T, R> var1, Policy<R> var2);

    private class LazyObjectRelationshipIterator
    extends AbstractUntypedIteratorDecorator<ObjectRelationship<IMObject, R>, ObjectRelationship<T, R>> {
        public LazyObjectRelationshipIterator(Iterable<ObjectRelationship<IMObject, R>> iterable) {
            super(iterable.iterator());
        }

        public ObjectRelationship<T, R> next() {
            ObjectRelationship relationship = (ObjectRelationship)this.getIterator().next();
            Object object = null;
            if (relationship.getObject() != null) {
                object = AbstractRelatedDomainObjects.this.state.create((IMObject)relationship.getObject());
            }
            return new ObjectRelationshipImpl(object, relationship.getRelationship());
        }
    }

    private class LazyObjectIterator
    extends AbstractUntypedIteratorDecorator<IMObject, T> {
        public LazyObjectIterator(Iterable<IMObject> iterable) {
            super(iterable.iterator());
        }

        public T next() {
            return AbstractRelatedDomainObjects.this.state.create((IMObject)this.getIterator().next());
        }
    }

    protected static class State<T, R extends Relationship> {
        private final List<R> relationships;
        private final Class<T> type;
        private final Class<? extends T> fallbackType;
        private final boolean source;
        private final DomainService domainService;
        private final ArchetypeService service;

        State(List<R> relationships, Class<T> type, Class<? extends T> fallbackType, boolean source, DomainService domainService, ArchetypeService service) {
            this.relationships = relationships;
            this.type = type;
            this.fallbackType = fallbackType;
            this.source = source;
            this.domainService = domainService;
            this.service = service;
        }

        T create(IMObject object) {
            return this.domainService.create(object, this.type, this.fallbackType);
        }
    }
}

