/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.laboratory;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.component.business.domain.im.common.BeanEntityDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Identity;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Test;

public class TestImpl
extends BeanEntityDecorator
implements Test {
    private final DomainService service;

    public TestImpl(Entity entity, DomainService service) {
        super(entity, (IMObjectBeanFactory)service);
        this.service = service;
    }

    public String getCode() {
        return this.getCodeIdentity().getIdentity();
    }

    public Identity getCodeIdentity() {
        return (Identity)this.getBean().getObject("code", Identity.class);
    }

    public InvestigationType getInvestigationType() {
        IMObjectBean bean = this.getBean();
        Entity investigationType = (Entity)bean.getTarget("investigationType", Entity.class);
        if (investigationType == null) {
            throw new IllegalStateException("Test=" + this.getId() + " has no investigation type");
        }
        return this.service.create(investigationType, InvestigationType.class);
    }

    public boolean getGroup() {
        return this.getBean().getBoolean("group");
    }

    public String getTurnaround() {
        return this.getBean().getString("turnaround");
    }

    public String getSpecimen() {
        return this.getBean().getString("specimen");
    }

    public BigDecimal getPrice() {
        return this.getBean().getBigDecimal("price", BigDecimal.ZERO);
    }

    public Test.UseDevice getUseDevice() {
        return Test.UseDevice.valueOf((String)this.getBean().getString("useDevice"));
    }

    public List<Device> getDevices() {
        return this.getInvestigationType().getDevices();
    }
}

