/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.factory;

import java.util.List;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.RelatedObjects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.object.RelatedDomainObjects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

public class DomainServiceImpl
implements ApplicationContextAware,
DomainService {
    private final ArchetypeService service;
    private final ArchetypeHandlers<?> handlers;
    private BeanFactory beanFactory;
    private static final String NAME = "DomainObjectFactory.properties";
    private static final String FALLBACK_NAME = "DefaultDomainObjectFactory.properties";

    public DomainServiceImpl(ArchetypeService service) {
        this(NAME, FALLBACK_NAME, service);
    }

    public DomainServiceImpl(String name, String fallbackName, ArchetypeService service) {
        this.service = service;
        this.handlers = new ArchetypeHandlers(name, fallbackName, Object.class, "domain", service);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext instanceof AbstractRefreshableApplicationContext ? ((AbstractRefreshableApplicationContext)applicationContext).getBeanFactory() : applicationContext;
    }

    public IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    @Override
    public <R, T extends IMObject> R create(T object, Class<R> type) {
        return this.create(object, type, null);
    }

    @Override
    public <R, F extends R, T extends IMObject> R create(T object, Class<R> type, Class<F> fallbackType) {
        return this.doCreate(object, object.getArchetype(), type, fallbackType);
    }

    @Override
    public <R> R create(IMObjectBean bean, Class<R> type) {
        return this.doCreate(bean, bean.getObject().getArchetype(), type, null);
    }

    @Override
    public <R, T extends IMObject> R createBuilder(T parent, Class<R> type) {
        return this.doCreate(parent, type);
    }

    @Override
    public <T, R extends Relationship> RelatedDomainObjects<T, R> createRelatedObjects(List<R> relationships, Class<T> type) {
        return new RelatedDomainObjects<T, R>(relationships, type, false, this, this.service);
    }

    @Override
    public <T, F extends T, R extends Relationship> RelatedDomainObjects<T, R> createRelatedObjects(List<R> relationships, Class<T> type, Class<F> fallbackType) {
        return new RelatedDomainObjects<T, R>(relationships, type, fallbackType, false, this, this.service);
    }

    @Override
    public <T, R extends Relationship, P extends RelatedObjects<T, R, P>> P createRelated(List<R> relationships, Class<? extends P> type) {
        return (P)((RelatedObjects)this.doCreate(relationships, type));
    }

    public <R> R get(Reference reference, Class<R> type) {
        IMObject object = this.service.get(reference);
        return object != null ? (R)this.create(object, type) : null;
    }

    public <R> R get(Reference reference, Class<R> type, boolean active) {
        IMObject object = this.service.get(reference, active);
        return object != null ? (R)this.create(object, type) : null;
    }

    public <R> R get(String archetype, long id, Class<R> type) {
        IMObject object = this.service.get(archetype, id);
        return object != null ? (R)this.create(object, type) : null;
    }

    public <R> R get(String archetype, long id, Class<R> type, boolean active) {
        IMObject object = this.service.get(archetype, id, active);
        return object != null ? (R)this.create(object, type) : null;
    }

    private <R, F extends R> R doCreate(Object object, String archetype, Class<R> type, Class<F> fallbackType) {
        Object result;
        Object object2 = result = object instanceof IMObjectBean ? ((IMObjectBean)object).getObject() : object;
        if (!object.getClass().isAssignableFrom(type)) {
            ArchetypeHandler handler;
            boolean concrete;
            boolean bl = concrete = !type.isInterface();
            if (concrete) {
                handler = this.handlers.getHandler(type);
            } else {
                handler = this.handlers.getHandler(archetype);
                if (handler == null) {
                    handler = this.handlers.getHandler(type);
                }
            }
            if (handler != null) {
                result = this.doCreate(object, handler);
            } else if (fallbackType != null) {
                result = this.doCreate(object, fallbackType);
            } else if (concrete) {
                result = this.doCreate(object, type);
            }
        }
        if (!type.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException("No conversion from " + archetype + " to " + type.getName());
        }
        return type.cast(result);
    }

    private Object doCreate(Object object, ArchetypeHandler<?> handler) {
        return this.doCreate(object, handler.getType());
    }

    private <T> T doCreate(Object object, Class<T> type) {
        DomainObjectBeanFactory factory = new DomainObjectBeanFactory(object);
        return type.cast(factory.createBean(type, 3, false));
    }

    private class DomainObjectBeanFactory
    extends DefaultListableBeanFactory {
        private final Object object;

        public DomainObjectBeanFactory(Object object) {
            super(DomainServiceImpl.this.beanFactory);
            this.object = object;
            this.registerSingleton("_object", object);
            this.registerSingleton("archetypeService", DomainServiceImpl.this.service);
        }

        public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
            Class dependencyType = descriptor.getDependencyType();
            if (dependencyType.isAssignableFrom(this.object.getClass()) && !beanName.equals("_object")) {
                return false;
            }
            if (dependencyType.equals(ArchetypeService.class) && (beanName.equals("archetypeRuleService") || beanName.equals("pluginArchetypeService"))) {
                return false;
            }
            return super.isAutowireCandidate(beanName, descriptor);
        }
    }
}

