/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer.transaction;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.transaction.ChargeItem;
import org.openvpms.domain.internal.customer.transaction.TransactionItemImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.Patient;

public abstract class ChargeItemImpl
extends TransactionItemImpl
implements ChargeItem {
    private Patient patient;
    private Product product;
    private User clinician;

    public ChargeItemImpl(FinancialAct item, DomainService domainService) {
        super(item, domainService);
    }

    public ChargeItemImpl(IMObjectBean bean, DomainService domainService) {
        super(bean, domainService);
    }

    public Patient getPatient() {
        Party party;
        if (this.patient == null && (party = (Party)this.getBean().getTarget("patient", Party.class)) != null) {
            this.patient = this.getDomainService().create(party, Patient.class);
        }
        return this.patient;
    }

    public Product getProduct() {
        if (this.product == null) {
            this.product = (Product)this.getBean().getTarget("product", Product.class);
        }
        return this.product;
    }

    public BigDecimal getQuantity() {
        return this.getAct().getQuantity();
    }

    public User getClinician() {
        if (this.clinician == null) {
            this.clinician = (User)this.getBean().getTarget("clinician", User.class);
        }
        return this.clinician;
    }

    public BigDecimal getDiscount() {
        return this.getBean().getBigDecimal("discount", BigDecimal.ZERO);
    }

    public BigDecimal getDiscountTax() {
        BigDecimal total = this.getTotal();
        BigDecimal tax = this.getTotalTax();
        BigDecimal discount = this.getDiscount();
        return !MathRules.isZero((BigDecimal)total) ? MathRules.divide((BigDecimal)tax.multiply(discount), (BigDecimal)total, (int)2) : BigDecimal.ZERO;
    }

    public BigDecimal getTotalTax() {
        return this.getAct().getTaxAmount();
    }
}

