/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.builder;

import java.util.List;
import java.util.Objects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.domain.internal.builder.NodeValue;

public class TargetNodeValue
extends NodeValue {
    private final String archetype;

    public TargetNodeValue(String name) {
        this(name, null);
    }

    public TargetNodeValue(String name, String archetype) {
        super(name);
        this.archetype = archetype;
    }

    @Override
    public boolean update(IMObjectBean bean, Object value) {
        Reference reference;
        if (value instanceof Reference) {
            reference = (Reference)value;
        } else if (value instanceof IMObject) {
            reference = ((IMObject)value).getObjectReference();
        } else {
            throw new IllegalArgumentException("Argument 'value' must be a Reference or IMObject");
        }
        return this.update(bean, reference);
    }

    public boolean update(IMObjectBean bean, Reference reference) {
        String name = this.getName();
        boolean result = false;
        Relationship relationship = this.getRelationship(bean);
        if (reference != null) {
            if (relationship == null || !Objects.equals(relationship.getTarget(), reference)) {
                bean.setTarget(name, reference);
                result = true;
            }
        } else if (relationship != null) {
            bean.removeValue(name, (IMObject)relationship);
            result = true;
        }
        return result;
    }

    public Relationship getRelationship(IMObjectBean bean) {
        return this.getRelationship(bean, Relationship.class);
    }

    public <T extends Relationship> T getRelationship(IMObjectBean bean, Class<T> type) {
        return (T)((Relationship)bean.getObject(this.getName(), type));
    }

    public boolean update(IMObjectBean bean, IMObject target, String targetName) {
        boolean result = false;
        String name = this.getName();
        Relationship relationship = (Relationship)bean.getValue(name, Relationship.class, Predicates.isA((String[])new String[]{this.archetype}).and(Predicates.targetEquals((IMObject)target)));
        if (relationship == null) {
            bean.addTarget(name, target, targetName);
            result = true;
        }
        return result;
    }

    public boolean remove(IMObjectBean bean, IMObject target, String targetName) {
        boolean result = false;
        String name = this.getName();
        List relationships = bean.getValues(name, Relationship.class, Predicates.targetEquals((IMObject)target));
        if (relationships.isEmpty()) {
            bean.removeTargets(this.getName(), target, targetName);
            result = true;
        }
        return result;
    }
}

