/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.builder;

import java.util.HashSet;
import java.util.List;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.builder.DomainObjectBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.sync.Changes;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class EntityBuilder<D, B extends EntityBuilder<D, B>>
extends DomainObjectBuilder<D, Entity, B> {
    private final String supportedIdArchetype;
    private final PlatformTransactionManager transactionManager;
    private final NodeValue name = new NodeValue("name");
    private final NodeValue description = new NodeValue("description");
    private final NodeValue active = new NodeValue("active");
    private Changes<Entity> changes;
    private String entityIdArchetype;
    private String entityId;
    private String entityIdName;

    public EntityBuilder(String archetype, String supportedIdArchetype, Class<D> domainClass, ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        super(archetype, Entity.class, domainClass, service, domainService);
        this.supportedIdArchetype = supportedIdArchetype;
        this.transactionManager = transactionManager;
    }

    public B changes(Changes<Entity> changes) {
        this.changes = changes;
        return (B)((EntityBuilder)this.getThis());
    }

    public B entityId(String archetype, String id) {
        return this.entityId(archetype, id, null);
    }

    public B entityId(String archetype, String id, String name) {
        this.entityIdArchetype = archetype;
        this.entityId = id;
        this.entityIdName = name;
        return (B)((EntityBuilder)this.getThis());
    }

    public B entityIdName(String name) {
        this.entityIdName = name;
        return (B)((EntityBuilder)this.getThis());
    }

    public B name(String name) {
        return (B)((EntityBuilder)this.setValue(this.name, name));
    }

    public B description(String description) {
        return (B)((EntityBuilder)this.setValue(this.description, description));
    }

    public B active(boolean active) {
        return (B)((EntityBuilder)this.setValue(this.active, active));
    }

    @Override
    public D build(boolean save) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (D)template.execute(status -> super.build(save));
    }

    @Override
    protected Entity getObject(String archetype) {
        if (this.entityIdArchetype == null) {
            throw new IllegalStateException("No identifier archetype provided");
        }
        if (!TypeHelper.matches((String)this.entityIdArchetype, (String)this.supportedIdArchetype)) {
            throw new IllegalStateException("Expected entity identity archetype: " + this.supportedIdArchetype + " but got: " + this.entityIdArchetype);
        }
        if (this.entityId == null) {
            throw new IllegalStateException("No identifier provided");
        }
        Entity result = this.getEntity(this.entityIdArchetype, this.entityId);
        if (result == null) {
            result = this.create(archetype);
        }
        return result;
    }

    @Override
    protected boolean build(DomainObjectBuilder.State state) {
        Entity object = (Entity)state.getObject();
        boolean changed = this.populate(object, state.getBean());
        if (changed) {
            state.addChanged((IMObject)object);
        }
        if (this.changes != null) {
            if (object.isNew()) {
                this.changes.added((Object)object);
            } else if (changed) {
                this.changes.updated((Object)object);
            }
        }
        this.reset();
        return changed;
    }

    protected Entity create(String archetype) {
        Entity entity = this.create(archetype, Entity.class);
        entity.addIdentity(this.createIdentity(this.entityIdArchetype, this.entityId, this.entityIdName));
        return entity;
    }

    protected boolean populate(Entity entity, IMObjectBean bean) {
        boolean changed = this.name.update(bean);
        changed |= this.description.update(bean);
        return changed |= this.active.update(bean);
    }

    protected abstract Entity getEntity(String var1, String var2);

    protected void reset() {
        this.changes = null;
        this.entityIdArchetype = null;
        this.entityId = null;
        this.entityIdName = null;
        this.reset(this.name, this.description, this.active);
    }

    protected EntityIdentity createIdentity(String archetype, String id, String name) {
        EntityIdentity identity = this.create(archetype, EntityIdentity.class);
        identity.setIdentity(id);
        if (name != null) {
            identity.setName(name);
        } else {
            identity.setName(id);
        }
        return identity;
    }

    protected boolean updateRelationships(IMObjectBean bean, String node, List<? extends Entity> targets) {
        boolean changed = false;
        HashSet<Reference> targetRefs = new HashSet<Reference>();
        for (Entity entity : targets) {
            targetRefs.add(entity.getObjectReference());
        }
        List existing = bean.getTargetRefs(node);
        HashSet hashSet = new HashSet(targetRefs);
        existing.forEach(hashSet::remove);
        HashSet toRemove = new HashSet(existing);
        toRemove.removeAll(targetRefs);
        for (Reference reference : hashSet) {
            bean.addTarget(node, reference);
            changed = true;
        }
        for (Reference reference : toRemove) {
            bean.removeTarget(node, reference);
            changed = true;
        }
        return changed;
    }
}

