/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.factory.DomainService;

public abstract class DomainObjectBuilder<D, T extends IMObject, B extends DomainObjectBuilder<D, T, B>> {
    private final T existing;
    private final String archetype;
    private final Class<D> domainType;
    private final Class<T> modelType;
    private final ArchetypeService service;
    private final DomainService domainService;

    public DomainObjectBuilder(Class<T> modelType, Class<D> domainType, ArchetypeService service, DomainService domainService) {
        this(null, null, modelType, domainType, service, domainService);
    }

    public DomainObjectBuilder(String archetype, Class<T> modelType, Class<D> domainType, ArchetypeService service, DomainService domainService) {
        this(null, archetype, modelType, domainType, service, domainService);
    }

    public DomainObjectBuilder(T object, Class<D> domainType, ArchetypeService service, DomainService domainService) {
        this(object, object.getArchetype(), object.getClass(), domainType, service, domainService);
    }

    private DomainObjectBuilder(T object, String archetype, Class<T> modelType, Class<D> domainType, ArchetypeService service, DomainService domainService) {
        this.existing = object;
        this.archetype = archetype;
        this.modelType = modelType;
        this.domainType = domainType;
        this.service = service;
        this.domainService = domainService;
    }

    public D build() {
        return this.build(true);
    }

    public D build(boolean save) {
        T object = this.getObject(this.archetype);
        State state = new State(this, object);
        boolean changed = this.build(state);
        if (save && changed) {
            this.service.save(state.getChanged());
        }
        return state.getDomainObject();
    }

    protected abstract boolean build(State var1);

    protected <A extends IMObject, C> C create(A object, Class<C> type) {
        return this.domainService.create(object, type);
    }

    protected T getObject(String archetype) {
        Object result = this.existing != null && this.existing.isA(archetype) ? this.existing : this.service.create(archetype, this.modelType);
        return (T)result;
    }

    protected T getExisting() {
        return this.existing;
    }

    protected B setValue(NodeValue node, Object value) {
        node.setValue(value);
        return this.getThis();
    }

    protected B getThis() {
        return (B)this;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    protected <O extends IMObject> O create(String archetype, Class<O> type) {
        return (O)this.service.create(archetype, type);
    }

    protected boolean update(IMObjectBean bean, NodeValue ... values) {
        boolean changed = false;
        for (NodeValue value : values) {
            changed |= value.update(bean);
        }
        return changed;
    }

    protected void reset(NodeValue ... values) {
        for (NodeValue value : values) {
            value.reset();
        }
    }

    protected static class State {
        private final T object;
        private final IMObjectBean bean;
        private final Set<IMObject> changed = new LinkedHashSet<IMObject>();
        private D domainObject;
        final /* synthetic */ DomainObjectBuilder this$0;

        public State(T object) {
            this.this$0 = this$0;
            this.object = object;
            this.bean = ((DomainObjectBuilder)this$0).service.getBean(object);
            if (object.isNew()) {
                this.addChanged((IMObject)object);
            }
            if (((DomainObjectBuilder)this$0).domainType.isAssignableFrom(object.getClass())) {
                this.domainObject = ((DomainObjectBuilder)this$0).domainType.cast(object);
            }
        }

        public T getObject() {
            return this.object;
        }

        public IMObjectBean getBean() {
            return this.bean;
        }

        public void addChanged(IMObject object) {
            this.changed.add(object);
        }

        public Set<IMObject> getChanged() {
            return this.changed;
        }

        public D getDomainObject() {
            if (this.domainObject == null) {
                this.domainObject = this.this$0.create(this.object, this.this$0.domainType);
            }
            return this.domainObject;
        }
    }
}

