/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.till;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.internal.test.AbstractDomainObjectTest;
import org.openvpms.domain.internal.till.TillImpl;
import org.openvpms.domain.till.DrawerCommand;
import org.openvpms.domain.till.Till;
import org.springframework.beans.factory.annotation.Autowired;

public class TillImplTestCase
extends AbstractDomainObjectTest {
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Override
    public void testEquality() {
        Entity till1 = (Entity)this.practiceFactory.newTill().build(false);
        Entity till2 = (Entity)this.practiceFactory.newTill().build(false);
        this.checkEquality((IMObject)till1, (IMObject)till2, Till.class);
    }

    @Override
    public void testFactory() {
        Entity till = (Entity)this.practiceFactory.newTill().build(false);
        this.checkFactory((IMObject)till, Till.class, TillImpl.class);
    }

    @Test
    public void testGetDrawerCommand() {
        Till till1 = this.createTill(null, null);
        Assert.assertNull((Object)till1.getDrawerCommand());
        Till till2 = this.createTill("printer", null);
        Assert.assertNull((Object)till2.getDrawerCommand());
        Till till3 = this.createTill(null, "1,2,3");
        Assert.assertNull((Object)till3.getDrawerCommand());
        Till till4 = this.createTill("printer", "invalid command");
        Assert.assertNull((Object)till4.getDrawerCommand());
        Till till5 = this.createTill("printer", "27,112,0,50,250");
        DrawerCommand drawerCommand5 = till5.getDrawerCommand();
        Assert.assertNotNull((Object)drawerCommand5);
        Assert.assertEquals((Object)"printer", (Object)drawerCommand5.getPrinter());
        Assert.assertNull((Object)drawerCommand5.getPrinterServiceArchetype());
        Assert.assertArrayEquals((byte[])new byte[]{27, 112, 0, 50, -6}, (byte[])drawerCommand5.getCommand());
        Till till6 = this.createTill("entity.printerServiceTest:printer", "27,112,0,50,250");
        DrawerCommand drawerCommand6 = till6.getDrawerCommand();
        Assert.assertEquals((Object)"printer", (Object)drawerCommand6.getPrinter());
        Assert.assertEquals((Object)"entity.printerServiceTest", (Object)drawerCommand6.getPrinterServiceArchetype());
        Assert.assertArrayEquals((byte[])new byte[]{27, 112, 0, 50, -6}, (byte[])drawerCommand6.getCommand());
    }

    private Till createTill(String printer, String drawerCommand) {
        Entity till = (Entity)this.practiceFactory.newTill().printer(printer).drawerCommand(drawerCommand).build(false);
        return (Till)this.getDomainService().create((IMObject)till, Till.class);
    }
}

