/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.patient.PatientQueryImpl;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.query.Active;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.patient.PatientQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientQueryImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private DomainService domainService;

    @Test
    public void testQueryById() {
        Patient patient = (Patient)this.domainService.create((IMObject)this.patientFactory.createPatient(), Patient.class);
        PatientQuery query = (PatientQuery)this.getQuery().id(patient.getId());
        this.checkQuery(query, patient);
        Assert.assertEquals((Object)patient, (Object)query.findFirst());
    }

    @Test
    public void testQueryByName() {
        String name = ValueStrategy.randomString();
        Patient patientA = this.createPatient(name);
        Patient patientB = this.createPatient(name);
        PatientQuery query = (PatientQuery)this.getQuery().name(name);
        this.checkQuery(query, patientA, patientB);
    }

    @Test
    public void testQueryByNameFilter() {
        String name = ValueStrategy.randomString();
        Patient patientA = this.createPatient(name + "A");
        Patient patientB = this.createPatient(name + "B");
        PatientQuery query1 = (PatientQuery)this.getQuery().name(Filter.like((String)(name + "%")));
        this.checkQuery(query1, patientA, patientB);
    }

    @Test
    public void testQueryByActiveInactive() {
        String microchip = ValueStrategy.randomString();
        Patient patientA = this.createPatient("A", microchip, true);
        Patient patientB = this.createPatient("B", microchip, false);
        Patient patientC = this.createPatient("C", microchip, true);
        PatientQuery query1 = this.getQuery().microchip(microchip);
        this.checkQuery(query1, patientA, patientB, patientC);
        PatientQuery query2 = (PatientQuery)this.getQuery().microchip(microchip).active();
        this.checkQuery(query2, patientA, patientC);
        PatientQuery query3 = (PatientQuery)this.getQuery().microchip(microchip).inactive();
        this.checkQuery(query3, patientB);
    }

    @Test
    public void testQueryByMicrochip() {
        String microchip1 = ValueStrategy.randomString();
        String microchip2 = ValueStrategy.randomString();
        Patient patientA = this.createPatient("A", microchip1);
        Patient patientB = this.createPatient("B", microchip1);
        Patient patientC = this.createPatient("C", microchip2);
        PatientQuery query1 = this.getQuery().microchip(microchip1);
        this.checkQuery(query1, patientA, patientB);
        PatientQuery query2 = this.getQuery().microchip(microchip2);
        Assert.assertEquals((Object)patientC, (Object)query2.findFirst());
        this.checkQuery(query2, patientC);
    }

    @Test
    public void testQueryByMicrochipFilter() {
        String microchip = ValueStrategy.randomString();
        Patient patientA = this.createPatient("Spot", microchip + "A");
        Patient patientB = this.createPatient("Fido", microchip + "B");
        PatientQuery query1 = this.getQuery().microchip(Filter.like((String)(microchip + "%")));
        this.checkQuery(query1, patientA, patientB);
    }

    @Test
    public void testOrderById() {
        String microchip = ValueStrategy.randomString();
        Patient patientA = this.createPatient("A", microchip);
        Patient patientB = this.createPatient("B", microchip);
        Patient patientC = this.createPatient("C", microchip);
        PatientQuery query1 = this.getQuery().microchip(microchip);
        this.checkQuery(query1, patientA, patientB, patientC);
        PatientQuery query2 = (PatientQuery)this.getQuery().microchip(microchip).orderById();
        this.checkQuery(query2, patientA, patientB, patientC);
        PatientQuery query3 = (PatientQuery)this.getQuery().microchip(microchip).orderById(true);
        this.checkQuery(query3, patientA, patientB, patientC);
        PatientQuery query4 = (PatientQuery)this.getQuery().microchip(microchip).orderById(false);
        this.checkQuery(query4, patientC, patientB, patientA);
    }

    @Test
    public void testOrderByName() {
        String microchip = ValueStrategy.randomString();
        Patient patientA = this.createPatient("Spot", microchip);
        Patient patientB = this.createPatient("Fido", microchip);
        Patient patientC = this.createPatient("Fido", microchip);
        Assert.assertTrue((patientB.getId() < patientC.getId() ? 1 : 0) != 0);
        PatientQuery query1 = (PatientQuery)this.getQuery().microchip(microchip).orderByName();
        this.checkQuery(query1, patientB, patientC, patientA);
        PatientQuery query2 = (PatientQuery)this.getQuery().microchip(microchip).orderByName(true);
        this.checkQuery(query2, patientB, patientC, patientA);
        PatientQuery query3 = (PatientQuery)this.getQuery().microchip(microchip).orderByName(false);
        this.checkQuery(query3, patientA, patientB, patientC);
        PatientQuery query4 = (PatientQuery)((PatientQuery)this.getQuery().microchip(microchip).orderByName(true)).orderById(false);
        this.checkQuery(query4, patientC, patientB, patientA);
    }

    @Test
    public void testQueryByOwner() {
        Customer customer = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Patient patient1 = this.createPatient(customer);
        Patient patient2 = this.createPatient(customer);
        PatientQuery query1 = this.getQuery().owner(customer);
        this.checkQuery(query1, patient1, patient2);
        PatientQuery query2 = this.getQuery().owner(customer.getId());
        this.checkQuery(query2, patient1, patient2);
    }

    @Test
    public void testQueryByOwnerActiveInactive() {
        Customer customerA = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customerB = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().active(false)).build(), Customer.class);
        String microchip = ValueStrategy.randomString();
        Patient patient1 = this.createPatient(customerA, microchip);
        Patient patient2 = this.createPatient(customerA, microchip);
        Patient patient3 = this.createPatient(customerB, microchip);
        Patient patient4 = this.createPatient(customerC, microchip);
        PatientQuery query1 = (PatientQuery)this.getQuery().microchip(microchip).orderById();
        this.checkQuery(query1, patient1, patient2, patient3, patient4);
        PatientQuery query2 = (PatientQuery)this.getQuery().activeOwner().microchip(microchip).orderById();
        this.checkQuery(query2, patient1, patient2, patient3);
        PatientQuery query3 = (PatientQuery)this.getQuery().inactiveOwner().microchip(microchip).orderById();
        this.checkQuery(query3, patient4);
        PatientQuery query4 = (PatientQuery)this.getQuery().activeOwner(Active.ALL).microchip(microchip).orderById();
        this.checkQuery(query4, patient1, patient2, patient3, patient4);
    }

    @Test
    public void testQueryByOwnerName() {
        String suffix = ValueStrategy.randomString();
        String lastNameA = "Smith" + suffix;
        String lastNameB = "Smyth" + suffix;
        String lastNameC = "Smithers" + suffix;
        Customer customerA = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Jo", lastNameA), Customer.class);
        Customer customerB = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Jo", lastNameB), Customer.class);
        Customer customerC = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer("Joanna", lastNameC), Customer.class);
        Patient patient1 = this.createPatient(customerA);
        Patient patient2 = this.createPatient(customerB);
        Patient patient3 = this.createPatient(customerC);
        PatientQuery query1 = this.getQuery().ownerName(lastNameA);
        this.checkQuery(query1, patient1);
        PatientQuery query2 = this.getQuery().ownerName(lastNameA, "Jo");
        this.checkQuery(query2, patient1);
        PatientQuery query3 = this.getQuery().ownerName(lastNameA, "Joanna");
        this.checkQuery(query3, new Patient[0]);
        PatientQuery query4 = this.getQuery().ownerName(Filter.equal((Object)lastNameA));
        this.checkQuery(query4, patient1);
        PatientQuery query5 = this.getQuery().ownerName(Filter.equal((Object)lastNameB), Filter.equal((Object)"Jo"));
        this.checkQuery(query5, patient2);
        PatientQuery query6 = this.getQuery().ownerName(lastNameA);
        this.checkQuery(query6, patient1);
        PatientQuery query7 = this.getQuery().ownerName(Filter.like((String)("Smith%" + suffix)));
        this.checkQuery(query7, patient1, patient3);
        PatientQuery query8 = this.getQuery().ownerName(Filter.like((String)("S%" + suffix)), Filter.like((String)"Joan%"));
        this.checkQuery(query8, patient3);
        PatientQuery query9 = this.getQuery().ownerName(Filter.like((String)("S%" + suffix)), Filter.like((String)"J%"));
        this.checkQuery(query9, patient1, patient2, patient3);
    }

    @Test
    public void testQueryByOwnerAddress() {
        String name = ValueStrategy.randomString();
        Lookup suburb1 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup suburb2 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup vic = this.lookupFactory.getLookup("lookup.state", "VIC", "Victoria");
        Lookup nsw = this.lookupFactory.getLookup("lookup.state", "NSW", "New South Wales");
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addAddress("1024 Broadwater Avenue", suburb1.getCode(), vic.getCode(), "3925", new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addAddress("1024 Broadwater St", suburb1.getCode(), vic.getCode(), "3925", new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addAddress("1024 Broadwater St", suburb2.getCode(), nsw.getCode(), "2360", new String[0])).build(), Customer.class);
        Patient patient1 = this.createPatient(name, customerA);
        Patient patient2 = this.createPatient(name, customerB);
        Patient patient3 = this.createPatient(name, customerC);
        PatientQuery query1 = ((PatientQuery)this.getQuery().name(name)).ownerAddress("1024 Broadwater Avenue", suburb1.getName(), "3925", vic.getName());
        this.checkQuery(query1, patient1);
        PatientQuery query2 = ((PatientQuery)this.getQuery().name(name)).ownerAddress("1024 Broadwater St", null, null, null);
        this.checkQuery(query2, patient2, patient3);
        PatientQuery query3 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, suburb1.getName(), null, null);
        this.checkQuery(query3, patient1, patient2);
        PatientQuery query4 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, null, "3925", null);
        this.checkQuery(query4, patient1, patient2);
        PatientQuery query5 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, null, null, vic.getName());
        this.checkQuery(query5, patient1, patient2);
        PatientQuery query6 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(Filter.like((String)"1024 Broadwater%"), null, null, null);
        this.checkQuery(query6, patient1, patient2, patient3);
        PatientQuery query7 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, Filter.like((String)(suburb1.getName() + "%")), null, null);
        this.checkQuery(query7, patient1, patient2);
        PatientQuery query9 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, null, Filter.like((String)"236%"), null);
        this.checkQuery(query9, patient3);
        PatientQuery query10 = ((PatientQuery)this.getQuery().name(name)).ownerAddress(null, null, null, Filter.like((String)"Vic%"));
        this.checkQuery(query10, patient1, patient2);
    }

    @Test
    public void testQueryByOwnerEmail() {
        String prefix = ValueStrategy.randomString();
        String emailA = prefix + "A@gmail.com";
        String emailB = prefix + "B@gmail.com";
        String emailC = prefix + "C@gmail.com";
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailA, new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailB, new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail(emailC, new String[0])).build(), Customer.class);
        Patient patient1 = this.createPatient(customerA);
        Patient patient2 = this.createPatient(customerB);
        Patient patient3 = this.createPatient(customerC);
        PatientQuery query1 = this.getQuery().ownerEmail(emailA);
        this.checkQuery(query1, patient1);
        PatientQuery query2 = this.getQuery().ownerEmail(Filter.equal((Object)emailB));
        this.checkQuery(query2, patient2);
        PatientQuery query3 = this.getQuery().ownerEmail(Filter.like((String)(prefix + "%")));
        this.checkQuery(query3, patient1, patient2, patient3);
    }

    @Test
    public void testQueryByOwnerPhone() {
        String prefix = ValueStrategy.randomString();
        String phoneA = prefix + "1";
        String phoneB = prefix + "2";
        String phoneC = prefix + "3";
        Customer customerA = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneA, new String[0])).build(), Customer.class);
        Customer customerB = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneB, new String[0])).build(), Customer.class);
        Customer customerC = (Customer)this.domainService.create(((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone(phoneC, new String[0])).build(), Customer.class);
        Patient patient1 = this.createPatient(customerA);
        Patient patient2 = this.createPatient(customerB);
        Patient patient3 = this.createPatient(customerC);
        PatientQuery query1 = this.getQuery().ownerPhone(phoneA);
        this.checkQuery(query1, patient1);
        PatientQuery query2 = this.getQuery().ownerPhone(Filter.equal((Object)phoneB));
        this.checkQuery(query2, patient2);
        PatientQuery query3 = this.getQuery().ownerPhone(Filter.like((String)(prefix + "%")));
        this.checkQuery(query3, patient1, patient2, patient3);
    }

    @Test
    public void testPriorOwnerRelationshipExcluded() {
        Customer customerA = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customerB = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customerC = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Patient patient1 = (Patient)this.domainService.create(this.patientFactory.newPatient().addOwner((Party)customerA, DateRules.getToday(), null).addOwner((Party)customerB, DateRules.getYesterday(), DateRules.getToday()).build(), Patient.class);
        Patient patient2 = (Patient)this.domainService.create(this.patientFactory.newPatient().addOwner((Party)customerB, DateRules.getToday(), null).addOwner((Party)customerC, DateRules.getYesterday(), DateRules.getToday()).build(), Patient.class);
        this.checkQuery(this.getQuery().owner(customerA), patient1);
        this.checkQuery(this.getQuery().owner(customerB), patient2);
        this.checkQuery(this.getQuery().owner(customerC), new Patient[0]);
    }

    private PatientQueryImpl getQuery() {
        return new PatientQueryImpl((ArchetypeService)this.getArchetypeService(), this.domainService);
    }

    private void checkQuery(PatientQuery query, Patient ... expected) {
        List matches = IterableUtils.toList((Iterable)query.query());
        Assert.assertEquals(Arrays.asList(expected), (Object)matches);
    }

    private Patient createPatient(String name) {
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name(name)).build();
        return (Patient)this.domainService.create((IMObject)patient, Patient.class);
    }

    private Patient createPatient(String name, String microchip) {
        return this.createPatient(name, microchip, true);
    }

    private Patient createPatient(String name, String microchip, boolean active) {
        Party patient = (Party)((TestPatientBuilder)((TestPatientBuilder)this.patientFactory.newPatient().name(name)).addMicrochip(microchip).active(active)).build();
        return (Patient)this.domainService.create((IMObject)patient, Patient.class);
    }

    private Patient createPatient(String name, Customer owner) {
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name(name)).owner((Party)owner).build();
        return (Patient)this.domainService.create((IMObject)patient, Patient.class);
    }

    private Patient createPatient(Customer owner) {
        Party patient = this.patientFactory.createPatient((Party)owner);
        return (Patient)this.domainService.create((IMObject)patient, Patient.class);
    }

    private Patient createPatient(Customer owner, String microchip) {
        Party patient = (Party)this.patientFactory.newPatient().owner((Party)owner).addMicrochip(microchip).build();
        return (Patient)this.domainService.create((IMObject)patient, Patient.class);
    }
}

