/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.customer.CustomerBuilderImpl;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.service.customer.CustomerBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerBuilderImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerRules rules;
    @Autowired
    private DomainService domainObjectService;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testNewCustomer() {
        this.lookupFactory.getLookup("lookup.personTitle", "MS");
        Lookup suburb = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup vic = this.lookupFactory.getLookup("lookup.state", "VIC", "Victoria");
        Location location = (Location)this.domainObjectService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Customer customer = this.getBuilder().title("MS").firstName("J").lastName("Smith").address("123 Smith St", suburb.getCode(), "3070", vic.getCode()).homePhone("11111111").workPhone("22222222").mobilePhone("33333333").email("foo@bar.com").practice(location).active(true).build();
        Assert.assertNotEquals((long)customer.getId(), (long)-1L);
        Assert.assertEquals((Object)"MS", (Object)customer.getTitleCode());
        Assert.assertEquals((Object)"J", (Object)customer.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)customer.getLastName());
        Assert.assertEquals((long)1L, (long)customer.getAddresses().size());
        Address address = customer.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"123 Smith St", (Object)address.getAddress());
        Assert.assertEquals((Object)suburb.getCode(), (Object)address.getSuburbCode());
        Assert.assertEquals((Object)"3070", (Object)address.getPostcode());
        Assert.assertEquals((Object)vic.getCode(), (Object)address.getStateCode());
        Assert.assertEquals((long)3L, (long)customer.getPhones().size());
        Assert.assertEquals((Object)"11111111", (Object)customer.getHomePhone().getPhoneNumber());
        Assert.assertEquals((Object)"22222222", (Object)customer.getWorkPhone().getPhoneNumber());
        Assert.assertEquals((Object)"33333333", (Object)customer.getMobilePhone().getPhoneNumber());
        Assert.assertEquals((Object)"foo@bar.com", (Object)customer.getEmail().getEmailAddress());
        Assert.assertTrue((boolean)customer.isActive());
        Assert.assertEquals((Object)location, (Object)customer.getPractice());
    }

    @Test
    public void testUpdateCustomer() {
        this.lookupFactory.getLookup("lookup.personTitle", "MS");
        this.lookupFactory.getLookup("lookup.personTitle", "DR");
        Lookup suburb1 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup suburb2 = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.suburb").uniqueCode()).build();
        Lookup state1 = this.lookupFactory.getLookup("lookup.state", "VIC");
        Lookup state2 = this.lookupFactory.getLookup("lookup.state", "NSW");
        Location location1 = (Location)this.domainObjectService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Location location2 = (Location)this.domainObjectService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").address("123 Smith St", suburb1.getCode(), "3070", state1.getCode()).homePhone("11111111").workPhone("22222222").mobilePhone("33333333").email("foo@bar.com").practice(location1).active(true).build();
        this.getBuilder((Party)customer1).title("DR").firstName("Jo").lastName("Smyth").address("234 Main St", suburb2.getCode(), "2000", state2.getCode()).homePhone("22222222").workPhone("33333333").mobilePhone("44444444").email("foo@bar.org").practice(location2).active(false).build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((Object)"DR", (Object)customer2.getTitleCode());
        Assert.assertEquals((Object)"Jo", (Object)customer2.getFirstName());
        Assert.assertEquals((Object)"Smyth", (Object)customer2.getLastName());
        Assert.assertEquals((long)1L, (long)customer2.getAddresses().size());
        Address address = customer2.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"234 Main St", (Object)address.getAddress());
        Assert.assertEquals((Object)suburb2.getCode(), (Object)address.getSuburbCode());
        Assert.assertEquals((Object)"2000", (Object)address.getPostcode());
        Assert.assertEquals((Object)state2.getCode(), (Object)address.getStateCode());
        Assert.assertEquals((long)3L, (long)customer2.getPhones().size());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getHomePhone().getPhoneNumber());
        Assert.assertEquals((Object)"33333333", (Object)customer2.getWorkPhone().getPhoneNumber());
        Assert.assertEquals((Object)"44444444", (Object)customer2.getMobilePhone().getPhoneNumber());
        Assert.assertEquals((Object)"foo@bar.org", (Object)customer2.getEmail().getEmailAddress());
        Assert.assertFalse((boolean)customer2.isActive());
        Assert.assertEquals((Object)location2, (Object)customer2.getPractice());
    }

    @Test
    public void testIdenticalNumbersMappedToSamePhoneContact() {
        Customer customer = this.getBuilder().title("MS").firstName("J").lastName("Smith").homePhone("11111111").workPhone("11111111").mobilePhone("11111111").build();
        Assert.assertEquals((long)1L, (long)customer.getContacts().size());
        Phone homePhone = customer.getHomePhone();
        Phone workPhone = customer.getWorkPhone();
        Phone mobilePhone = customer.getMobilePhone();
        Assert.assertEquals((Object)"11111111", (Object)homePhone.getPhoneNumber());
        Assert.assertEquals((Object)homePhone, (Object)workPhone);
        Assert.assertEquals((Object)homePhone, (Object)mobilePhone);
    }

    @Test
    public void testUpdateHomePhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").homePhone("11111111").build();
        this.getBuilder((Party)customer1).homePhone("22222222").build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)1L, (long)customer2.getContacts().size());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getHomePhone().getPhoneNumber());
        Assert.assertNull((Object)customer2.getWorkPhone());
        Assert.assertNull((Object)customer2.getMobilePhone());
    }

    @Test
    public void testUpdateWorkPhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").workPhone("11111111").build();
        this.getBuilder((Party)customer1).workPhone("22222222").build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)1L, (long)customer2.getContacts().size());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getWorkPhone().getPhoneNumber());
        Assert.assertNull((Object)customer2.getHomePhone());
        Assert.assertNull((Object)customer2.getMobilePhone());
    }

    @Test
    public void testUpdateMobilePhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").mobilePhone("11111111").build();
        this.getBuilder((Party)customer1).mobilePhone("22222222").build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)1L, (long)customer2.getContacts().size());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getMobilePhone().getPhoneNumber());
        Assert.assertNull((Object)customer2.getHomePhone());
        Assert.assertNull((Object)customer2.getWorkPhone());
    }

    @Test
    public void testRemoveHomePhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").homePhone("11111111").workPhone("22222222").mobilePhone("33333333").build();
        this.getBuilder((Party)customer1).homePhone(null).build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)2L, (long)customer2.getContacts().size());
        Assert.assertNull((Object)customer2.getHomePhone());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getWorkPhone().getPhoneNumber());
        Assert.assertEquals((Object)"33333333", (Object)customer2.getMobilePhone().getPhoneNumber());
    }

    @Test
    public void testRemoveWorkPhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").homePhone("11111111").workPhone("22222222").mobilePhone("33333333").build();
        this.getBuilder((Party)customer1).workPhone(null).build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)2L, (long)customer2.getContacts().size());
        Assert.assertNull((Object)customer2.getWorkPhone());
        Assert.assertEquals((Object)"11111111", (Object)customer2.getHomePhone().getPhoneNumber());
        Assert.assertEquals((Object)"33333333", (Object)customer2.getMobilePhone().getPhoneNumber());
    }

    @Test
    public void testRemoveMobilePhone() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").homePhone("11111111").workPhone("22222222").mobilePhone("33333333").build();
        this.getBuilder((Party)customer1).mobilePhone(null).build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)2L, (long)customer2.getContacts().size());
        Assert.assertNull((Object)customer2.getMobilePhone());
        Assert.assertEquals((Object)"11111111", (Object)customer2.getHomePhone().getPhoneNumber());
        Assert.assertEquals((Object)"22222222", (Object)customer2.getWorkPhone().getPhoneNumber());
    }

    @Test
    public void testUpdateEmail() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").email("foo@bar.com").build();
        this.getBuilder((Party)customer1).email("foo@bar.org").build();
        Customer customer2 = this.reload(customer1);
        Assert.assertEquals((long)1L, (long)customer2.getContacts().size());
        Assert.assertEquals((Object)"foo@bar.org", (Object)customer2.getEmail().getEmailAddress());
    }

    @Test
    public void testRemoveEmail() {
        Customer customer1 = this.getBuilder().title("MS").firstName("J").lastName("Smith").email("foo@bar.com").build();
        this.getBuilder((Party)customer1).email(null).build();
        Customer customer2 = this.reload(customer1);
        Assert.assertTrue((boolean)customer2.getContacts().isEmpty());
        Assert.assertNull((Object)customer2.getEmail());
    }

    private CustomerBuilder getBuilder() {
        return new CustomerBuilderImpl(this.rules, (ArchetypeService)this.getArchetypeService(), this.domainObjectService, this.getLookupService());
    }

    private CustomerBuilder getBuilder(Party customer) {
        return new CustomerBuilderImpl(customer, this.rules, (ArchetypeService)this.getArchetypeService(), this.domainObjectService, this.getLookupService());
    }

    private Customer reload(Customer customer) {
        return (Customer)this.domainObjectService.create(this.get(customer.getObjectReference()), Customer.class);
    }
}

