/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.internal.patient.PatientImpl;
import org.openvpms.domain.internal.test.AbstractDomainObjectTest;
import org.openvpms.domain.patient.Microchip;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.alert.Allergy;
import org.openvpms.domain.patient.referral.Referral;
import org.openvpms.domain.patient.referral.Referrals;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientImplTestCase
extends AbstractDomainObjectTest {
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Override
    @Test
    public void testFactory() {
        Party party = (Party)this.patientFactory.newPatient().build(false);
        this.checkFactory((IMObject)party, Patient.class, PatientImpl.class);
    }

    @Override
    public void testEquality() {
        Party party1 = (Party)this.patientFactory.newPatient().build(false);
        Party party2 = (Party)this.patientFactory.newPatient().build(false);
        this.checkEquality((IMObject)party1, (IMObject)party2, Patient.class);
    }

    @Test
    public void testAccessors() {
        Party customer = this.customerFactory.createCustomer();
        Date dateOfBirth = TestHelper.getDate((String)"2013-01-01");
        Date dateOfDeath = TestHelper.getDate((String)"2019-01-01");
        Party party = (Party)this.patientFactory.newPatient().dateOfBirth(dateOfBirth).deceased(true).dateOfDeath(dateOfDeath).species("CANINE").breed("DINGO").female().desexed(true).colour("Tan").addMicrochip("123456789").owner(customer).build();
        this.patientFactory.createWeight(party, BigDecimal.TEN);
        Patient patient = (Patient)this.getDomainService().create((IMObject)party, Patient.class);
        Assert.assertEquals((Object)dateOfBirth, (Object)DateRules.toDate((LocalDate)patient.getDateOfBirth()));
        Assert.assertEquals((Object)dateOfDeath, (Object)DateRules.toDate((LocalDate)patient.getDateOfDeath()));
        Assert.assertTrue((boolean)patient.isDeceased());
        Microchip microchip = patient.getMicrochip();
        Assert.assertNotNull((Object)microchip);
        Assert.assertEquals((Object)"123456789", (Object)microchip.getIdentity());
        Assert.assertEquals((Object)"CANINE", (Object)patient.getSpeciesCode());
        Assert.assertEquals((Object)"DINGO", (Object)patient.getBreedCode());
        Assert.assertEquals((Object)Patient.Sex.FEMALE, (Object)patient.getSex());
        Assert.assertTrue((boolean)patient.isDesexed());
        Assert.assertEquals((Object)"Tan", (Object)patient.getColourName());
        Assert.assertEquals((long)customer.getId(), (long)patient.getOwner().getId());
        Weight weight = patient.getWeight();
        Assert.assertNotNull((Object)weight);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)weight.getWeight());
        Assert.assertEquals((Object)WeightUnits.KILOGRAMS, (Object)weight.getUnits());
    }

    @Test
    public void testBreed() {
        Party party1 = (Party)this.patientFactory.newPatient().species("CANINE").breed("KELPIE").build();
        Patient patient1 = (Patient)this.getDomainService().create((IMObject)party1, Patient.class);
        Assert.assertEquals((Object)"Kelpie", (Object)patient1.getBreedName());
        Assert.assertEquals((Object)"KELPIE", (Object)patient1.getBreedCode());
        Assert.assertNotNull((Object)patient1.getBreedLookup());
        Assert.assertEquals((Object)"KELPIE", (Object)patient1.getBreedLookup().getCode());
        Assert.assertEquals((Object)"Kelpie", (Object)patient1.getBreedLookup().getName());
        Party party2 = (Party)this.patientFactory.newPatient().species("CANINE").build();
        Patient patient2 = (Patient)this.getDomainService().create((IMObject)party2, Patient.class);
        Assert.assertNull((Object)patient2.getBreedName());
        Assert.assertNull((Object)patient2.getBreedCode());
        Assert.assertNull((Object)patient2.getBreedLookup());
        Party party3 = (Party)this.patientFactory.newPatient().species("CANINE").newBreed("Bitzer").build();
        Patient patient3 = (Patient)this.getDomainService().create((IMObject)party3, Patient.class);
        Assert.assertEquals((Object)"Bitzer", (Object)patient3.getBreedName());
        Assert.assertNull((Object)patient3.getBreedCode());
        Assert.assertNull((Object)patient3.getBreedLookup());
        Party party4 = (Party)this.patientFactory.newPatient().species("CANINE").breed("BOXER").newBreed("Boxa").build();
        Patient patient4 = (Patient)this.getDomainService().create((IMObject)party4, Patient.class);
        Assert.assertEquals((Object)"Boxer", (Object)patient4.getBreedName());
        Assert.assertEquals((Object)"BOXER", (Object)patient4.getBreedCode());
        Assert.assertNotNull((Object)patient4.getBreedLookup());
        Assert.assertEquals((Object)"BOXER", (Object)patient4.getBreedLookup().getCode());
        Assert.assertEquals((Object)"Boxer", (Object)patient4.getBreedLookup().getName());
    }

    @Test
    public void testGetAge() {
        Party party1 = (Party)this.patientFactory.newPatient().build(false);
        Patient patient1 = (Patient)this.getDomainService().create((IMObject)party1, Patient.class);
        Assert.assertNull((Object)patient1.getAge());
        Assert.assertNull((Object)patient1.getAge(LocalDate.now()));
        Party party2 = (Party)this.patientFactory.newPatient().dateOfBirth(TestHelper.getDate((String)"2013-01-01")).build(false);
        Patient patient2 = (Patient)this.getDomainService().create((IMObject)party2, Patient.class);
        long years = patient2.getDateOfBirth().until(LocalDate.now(), ChronoUnit.YEARS);
        Assert.assertTrue((boolean)patient2.getAge().startsWith(years + " Years"));
        Assert.assertEquals((Object)"5 Years", (Object)patient2.getAge(LocalDate.of(2018, 1, 1)));
        Party party3 = (Party)this.patientFactory.newPatient().dateOfBirth(TestHelper.getDate((String)"2013-01-01")).deceased(true).dateOfDeath(TestHelper.getDate((String)"2017-01-01")).build(false);
        Patient patient3 = (Patient)this.getDomainService().create((IMObject)party3, Patient.class);
        Assert.assertEquals((Object)"4 Years", (Object)patient3.getAge());
        Assert.assertEquals((Object)"3 Years", (Object)patient2.getAge(LocalDate.of(2016, 1, 1)));
        Assert.assertEquals((Object)"4 Years", (Object)patient3.getAge(LocalDate.now()));
        Party party4 = (Party)this.patientFactory.newPatient().deceased(true).dateOfDeath(TestHelper.getDate((String)"2017-01-01")).build(false);
        Patient patient4 = (Patient)this.getDomainService().create((IMObject)party4, Patient.class);
        Assert.assertNull((Object)patient4.getAge());
        Assert.assertNull((Object)patient4.getAge(LocalDate.now()));
    }

    @Test
    public void testIsAggressive() {
        Party party = this.patientFactory.createPatient();
        Patient patient = (Patient)this.getDomainService().create((IMObject)party, Patient.class);
        Assert.assertFalse((boolean)patient.isAggressive());
        Entity type = (Entity)this.patientFactory.newAlertType().alertType("AGGRESSION").build();
        ((TestPatientAlertBuilder)this.patientFactory.newAlert().patient((Party)patient)).alertType(type).build();
        Assert.assertTrue((boolean)patient.isAggressive());
    }

    @Test
    public void testAllergies() {
        Party party = this.patientFactory.createPatient();
        Patient patient = (Patient)this.getDomainService().create((IMObject)party, Patient.class);
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        Assert.assertFalse((boolean)patient.getAllergies().getCurrent().iterator().hasNext());
        Entity type = (Entity)this.patientFactory.newAlertType().alertType("ALLERGY").build();
        ((TestPatientAlertBuilder)((TestPatientAlertBuilder)((TestPatientAlertBuilder)((TestPatientAlertBuilder)this.patientFactory.newAlert().startTime("2020-01-01")).patient((Party)patient)).alertType(type).reason("allergy 1")).notes("notes 1").clinician(clinician1)).build();
        ((TestPatientAlertBuilder)((TestPatientAlertBuilder)((TestPatientAlertBuilder)((TestPatientAlertBuilder)this.patientFactory.newAlert().startTime("2021-06-1")).patient((Party)patient)).alertType(type).reason("allergy 2")).notes("notes 2").clinician(clinician2)).build();
        ArrayList allergies = new ArrayList();
        CollectionUtils.addAll(allergies, patient.getAllergies().getCurrent().iterator());
        Assert.assertEquals((long)2L, (long)allergies.size());
        this.checkAllergy((Allergy)allergies.get(0), "2020-01-01", "allergy 1", "notes 1", clinician1);
        this.checkAllergy((Allergy)allergies.get(1), "2021-06-01", "allergy 2", "notes 2", clinician2);
    }

    @Test
    public void testReferrals() {
        Party party = this.patientFactory.createPatient();
        Patient patient = (Patient)this.getDomainService().create((IMObject)party, Patient.class);
        Referrals referrals = patient.getReferrals();
        Assert.assertNull((Object)referrals.getCurrent());
        Assert.assertNull((Object)referrals.getReferredFrom());
        Assert.assertNull((Object)referrals.getReferredTo());
        Assert.assertEquals((long)0L, (long)referrals.getAll().size());
        Party practice1 = this.supplierFactory.createVetPractice();
        Party practice2 = this.supplierFactory.createVetPractice();
        Party practice3 = this.supplierFactory.createVetPractice();
        Party vet1 = (Party)this.supplierFactory.newVet().addPractice(practice1).build();
        Party vet2 = (Party)this.supplierFactory.newVet().addPractice(practice2).build();
        Party vet3 = (Party)this.supplierFactory.newVet().addPractice(practice3).build();
        Date third = DateRules.getToday();
        Date first = DateRules.getDate((Date)third, (int)-2, (DateUnits)DateUnits.MONTHS);
        Date second = DateRules.getDate((Date)third, (int)-1, (DateUnits)DateUnits.DAYS);
        this.patientFactory.updatePatient((Party)patient).addReferredFrom(vet1, first, "reason 1").addReferredFrom(vet2, second, "reason 2").addReferredTo(vet3, third, "reason 3").build();
        this.checkReferral(referrals.getCurrent(), practice3, vet3, third, true, false, "reason 3");
        this.checkReferral(referrals.getReferredFrom(), practice2, vet2, second, false, true, "reason 2");
        Assert.assertNull((Object)referrals.getReferredFrom(true));
        this.checkReferral(referrals.getReferredFrom(false), practice2, vet2, second, false, true, "reason 2");
        this.checkReferral(referrals.getReferredTo(), practice3, vet3, third, true, false, "reason 3");
        this.checkReferral(referrals.getReferredTo(true), practice3, vet3, third, true, false, "reason 3");
        this.checkReferral(referrals.getReferredTo(false), practice3, vet3, third, true, false, "reason 3");
        Assert.assertNull((Object)referrals.getReferral(DateRules.toOffsetDateTime((Date)first).minusDays(1L)));
        this.checkReferral(referrals.getReferral(DateRules.toOffsetDateTime((Date)first)), practice1, vet1, first, false, true, "reason 1");
        this.checkReferral(referrals.getReferral(DateRules.toOffsetDateTime((Date)second)), practice2, vet2, second, false, true, "reason 2");
        this.checkReferral(referrals.getReferral(DateRules.toOffsetDateTime((Date)third)), practice3, vet3, third, true, false, "reason 3");
        this.checkReferral(referrals.getReferral(DateRules.toOffsetDateTime((Date)third).plusDays(1L)), practice3, vet3, third, true, false, "reason 3");
        Assert.assertEquals((long)3L, (long)referrals.getAll().size());
        this.checkReferral((Referral)referrals.getAll().get(0), practice3, vet3, third, true, false, "reason 3");
        this.checkReferral((Referral)referrals.getAll().get(1), practice2, vet2, second, false, true, "reason 2");
        this.checkReferral((Referral)referrals.getAll().get(2), practice1, vet1, first, false, true, "reason 1");
    }

    private void checkAllergy(Allergy actual, String date, String allergy, String notes, User clinician) {
        Assert.assertEquals((Object)DateRules.toOffsetDateTime((Date)TestHelper.getDate((String)date)), (Object)actual.getDate());
        Assert.assertEquals((Object)allergy, (Object)actual.getAllergy());
        Assert.assertEquals((Object)notes, (Object)actual.getNotes());
        Assert.assertEquals((Object)clinician, (Object)actual.getClinician());
    }

    private void checkReferral(Referral referral, Party practice, Party vet, Date date, boolean active, boolean from, String reason) {
        Assert.assertNotNull((Object)referral);
        Assert.assertEquals((Object)practice, (Object)referral.getPractice());
        Assert.assertEquals((Object)vet, (Object)referral.getVet());
        Assert.assertEquals((Object)date, (Object)DateRules.toDate((OffsetDateTime)referral.getDate()));
        Assert.assertEquals((Object)active, (Object)referral.isActive());
        Assert.assertEquals((Object)from, (Object)referral.referredFrom());
        Assert.assertEquals((Object)(!from ? 1 : 0), (Object)referral.referredTo());
        Assert.assertEquals((Object)reason, (Object)referral.getReason());
    }
}

