/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.service.patient.PatientBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientBuilderImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientServices patientServices;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testDescription() {
        this.lookupFactory.getBreed("KELPIE", "CANINE");
        PatientBuilderImpl builder = new PatientBuilderImpl(this.patientServices);
        Patient patient = builder.name("Fido").species("CANINE").breed("KELPIE").sex(Patient.Sex.MALE).colour("Black").microchip("123466789").build();
        Assert.assertEquals((Object)"Male Black Kelpie (Microchip: 123466789)", (Object)patient.getDescription());
        PatientBuilderImpl builder2 = new PatientBuilderImpl((Party)patient, this.patientServices);
        builder2.microchip("987654321").build();
        Assert.assertEquals((Object)"Male Black Kelpie (Microchip: 987654321)", (Object)patient.getDescription());
        ArrayList<String> microchips = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            String microchip = StringUtils.repeat((String)("" + i), (int)20);
            builder2.addMicrochip(microchip);
            microchips.add("Microchip: " + microchip);
        }
        builder2.build();
        String unabbreviated = "Male Black Kelpie (" + StringUtils.join(microchips, (String)", ") + ")";
        Assert.assertTrue((unabbreviated.length() > 255 ? 1 : 0) != 0);
        String abbreviated = StringUtils.abbreviate((String)unabbreviated, (int)255);
        Assert.assertEquals((long)255L, (long)abbreviated.length());
        Assert.assertTrue((boolean)abbreviated.endsWith("..."));
        Assert.assertEquals((Object)abbreviated, (Object)patient.getDescription());
    }
}

