/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.till;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.business.domain.im.common.BeanEntityDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.till.DrawerCommandImpl;
import org.openvpms.domain.till.DrawerCommand;
import org.openvpms.domain.till.Till;

public class TillImpl
extends BeanEntityDecorator
implements Till {
    public TillImpl(Entity peer, DomainService factory) {
        super(peer, (IMObjectBeanFactory)factory);
    }

    public TillImpl(IMObjectBean bean) {
        super(bean);
    }

    public DrawerCommand getDrawerCommand() {
        DrawerCommandImpl result = null;
        IMObjectBean bean = this.getBean();
        PrinterReference printer = PrinterReference.fromString((String)bean.getString("printerName"));
        if (printer != null) {
            String printerCommand = bean.getString("drawerCommand");
            byte[] command = null;
            if (!StringUtils.isEmpty((CharSequence)printerCommand)) {
                command = this.getCommand(printerCommand);
            }
            if (command != null) {
                result = new DrawerCommandImpl(printer.getId(), printer.getArchetype(), command);
            }
        }
        return result;
    }

    private byte[] getCommand(String command) {
        byte[] result = null;
        String[] codes = command.split(",");
        if (codes.length != 0) {
            result = new byte[codes.length];
            try {
                for (int i = 0; i < codes.length; ++i) {
                    int value = Integer.parseInt(codes[i].trim());
                    result[i] = (byte)value;
                }
            }
            catch (NumberFormatException exception) {
                result = null;
            }
        }
        return result;
    }
}

