/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.product;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.product.ProductQueryImpl;
import org.openvpms.domain.product.BaseProduct;
import org.openvpms.domain.product.Batch;
import org.openvpms.domain.service.product.ProductQuery;
import org.openvpms.domain.service.product.Products;

public class ProductsImpl
implements Products {
    private final ArchetypeService service;
    private final DomainService domainService;

    public ProductsImpl(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public Product getProduct(long id) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Product.class);
        Root from = query.from(Product.class, new String[]{"product.medication", "product.merchandise", "product.service", "product.template"});
        query.where((Expression)builder.equal((Expression)from.get("id"), (Object)id));
        Product result = (Product)this.service.createQuery(query).getFirstResult();
        return result != null ? (Product)this.domainService.create(result, BaseProduct.class) : null;
    }

    public ProductQuery getQuery() {
        return new ProductQueryImpl(this.service, this.domainService);
    }

    public Batch getBatch(Product product, String batchNumber) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root from = query.from(Entity.class, new String[]{"entity.productBatch"});
        Join join = from.join("product");
        join.on((Expression)builder.equal((Expression)join.get("target"), (Object)product.getObjectReference()));
        query.where((Expression)builder.equal((Expression)from.get("name"), (Object)batchNumber));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        Entity result = (Entity)this.service.createQuery(query).getFirstResult();
        return result != null ? this.domainService.create(result, Batch.class) : null;
    }
}

