/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.builder.DomainObjectBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.service.patient.PatientBuilder;

public class PatientBuilderImpl
extends DomainObjectBuilder<Patient, Party, PatientBuilderImpl>
implements PatientBuilder {
    private final PatientRules rules;
    private final NodeValue name = new NodeValue("name");
    private final NodeValue species = new NodeValue("species");
    private final NodeValue breed = new NodeValue("breed");
    private final NodeValue sex = new NodeValue("sex");
    private final NodeValue desexed = new NodeValue("desexed");
    private final NodeValue dateOfBirth = new NodeValue("dateOfBirth");
    private final NodeValue deceased = new NodeValue("deceased");
    private final NodeValue deceasedDate = new NodeValue("deceasedDate");
    private final NodeValue colour = new NodeValue("colour");
    private final NodeValue microchip = new NodeValue("identity");
    private final List<String> microchips = new ArrayList<String>();
    private final NodeValue active = new NodeValue("active");
    private MutableObject<Customer> owner;

    public PatientBuilderImpl(PatientServices patientServices) {
        super("party.patientpet", Party.class, Patient.class, patientServices.getArchetypeService(), patientServices.getDomainService());
        this.rules = patientServices.getPatientRules();
    }

    public PatientBuilderImpl(Party patient, PatientServices patientServices) {
        super(patient, Patient.class, patientServices.getArchetypeService(), patientServices.getDomainService());
        this.rules = patientServices.getPatientRules();
    }

    public PatientBuilder name(String name) {
        return (PatientBuilder)this.setValue(this.name, name);
    }

    public PatientBuilder species(String species) {
        return (PatientBuilder)this.setValue(this.species, species);
    }

    public PatientBuilder species(Lookup species) {
        return this.species(species != null ? species.getCode() : null);
    }

    public PatientBuilder breed(String breed) {
        return (PatientBuilder)this.setValue(this.breed, breed);
    }

    public PatientBuilder breed(Lookup breed) {
        return this.breed(breed != null ? breed.getCode() : null);
    }

    public PatientBuilder sex(Patient.Sex sex) {
        return (PatientBuilder)this.setValue(this.sex, sex != null ? sex.toString() : null);
    }

    public PatientBuilder desexed(boolean desexed) {
        return (PatientBuilder)this.setValue(this.desexed, desexed);
    }

    public PatientBuilder dateOfBirth(LocalDate dateOfBirth) {
        return (PatientBuilder)this.setValue(this.dateOfBirth, DateRules.toDate((LocalDate)dateOfBirth));
    }

    public PatientBuilder deceased(boolean deceased) {
        return (PatientBuilder)this.setValue(this.deceased, deceased);
    }

    public PatientBuilder dateOfDeath(LocalDate dateOfDeath) {
        return (PatientBuilder)this.setValue(this.deceasedDate, DateRules.toDate((LocalDate)dateOfDeath));
    }

    public PatientBuilder colour(String colour) {
        return (PatientBuilder)this.setValue(this.colour, colour);
    }

    public PatientBuilder owner(Customer owner) {
        this.owner = new MutableObject((Object)owner);
        return this;
    }

    public PatientBuilder microchip(String microchip) {
        return (PatientBuilder)this.setValue(this.microchip, microchip);
    }

    public PatientBuilder addMicrochip(String microchip) {
        this.microchips.add(microchip);
        return this;
    }

    public PatientBuilder active(boolean active) {
        return (PatientBuilder)this.setValue(this.active, active);
    }

    @Override
    protected boolean build(DomainObjectBuilder.State state) {
        Party object = (Party)state.getObject();
        state.addChanged((IMObject)object);
        IMObjectBean bean = state.getBean();
        this.update(bean, this.name, this.species, this.breed, this.sex, this.desexed, this.dateOfBirth, this.deceased, this.colour, this.active);
        if (this.deceased.getBoolean(bean)) {
            this.deceasedDate.update(bean);
        } else {
            this.deceasedDate.update(bean, null);
        }
        this.buildMicrochip(object);
        this.buildMicrochips(object, bean);
        this.buildOwner(object, bean, state);
        bean.deriveValues();
        return true;
    }

    private void buildMicrochip(Party object) {
        if (this.microchip.isSet()) {
            EntityIdentity identity = this.rules.getMicrochip(object);
            if (this.microchip.getValue() != null) {
                this.buildMicrochip(object, identity, this.microchip);
            } else if (identity != null) {
                object.removeIdentity(identity);
            }
        }
    }

    private void buildMicrochips(Party patient, IMObjectBean bean) {
        for (String microchip : this.microchips) {
            List existing = bean.getValues("identities", EntityIdentity.class, Predicates.isA((String[])new String[]{"entityIdentity.microchip"}));
            if (!existing.stream().noneMatch(identity -> StringUtils.equals((CharSequence)identity.getIdentity(), (CharSequence)microchip))) continue;
            this.buildMicrochip(patient, null, new NodeValue("identity", microchip));
        }
    }

    private void buildMicrochip(Party patient, EntityIdentity identity, NodeValue value) {
        IMObjectBean bean;
        if (identity == null) {
            identity = this.create("entityIdentity.microchip", EntityIdentity.class);
            patient.addIdentity(identity);
        }
        if (value.update(bean = this.getBean((IMObject)identity))) {
            bean.deriveValues();
        }
    }

    private void buildOwner(Party object, IMObjectBean bean, DomainObjectBuilder.State state) {
        if (this.owner != null) {
            Customer customer = (Customer)this.owner.getValue();
            Date now = new Date();
            Predicate predicate = Predicates.isA((String[])new String[]{"entityRelationship.patientOwner"}).and(Predicates.activeAt((Date)now));
            EntityRelationship relationship = (EntityRelationship)bean.getValue("customers", EntityRelationship.class, predicate);
            if (customer != null) {
                if (relationship != null) {
                    relationship.setActive(false);
                }
                this.rules.addPatientOwnerRelationship((Party)customer, object);
                state.addChanged((IMObject)customer);
            } else if (relationship != null) {
                relationship.setActive(false);
            }
        }
    }
}

