/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.customer.CustomerBuilderImpl;
import org.openvpms.domain.internal.service.customer.CustomerQueryImpl;
import org.openvpms.domain.service.customer.CustomerBuilder;
import org.openvpms.domain.service.customer.CustomerQuery;
import org.openvpms.domain.service.customer.Customers;

public class CustomersImpl
implements Customers {
    private final CustomerRules rules;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final LookupService lookups;

    public CustomersImpl(CustomerRules rules, ArchetypeService service, DomainService domainService, LookupService lookups) {
        this.rules = rules;
        this.service = service;
        this.domainService = domainService;
        this.lookups = lookups;
    }

    public Customer getCustomer(long id) {
        return (Customer)this.domainService.get("party.customerperson", id, Customer.class);
    }

    public CustomerQuery getQuery() {
        return new CustomerQueryImpl(this.service, this.domainService);
    }

    public CustomerBuilder getCustomerBuilder() {
        return new CustomerBuilderImpl(this.rules, this.service, this.domainService, this.lookups);
    }

    public CustomerBuilder getCustomerBuilder(Customer customer) {
        return new CustomerBuilderImpl((Party)customer, this.rules, this.service, this.domainService, this.lookups);
    }
}

