/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import java.util.List;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.From;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.AddressFilter;
import org.openvpms.domain.internal.query.PartyQueryImpl;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.customer.CustomerQuery;

public class CustomerQueryImpl
extends PartyQueryImpl<Customer, Party, CustomerQuery>
implements CustomerQuery {
    private AddressFilter address;
    private Filter<String> email;
    private Filter<String> phone;

    public CustomerQueryImpl(ArchetypeService service, DomainService domainService) {
        super("party.customerperson", Customer.class, Party.class, service, domainService);
    }

    @Override
    public CustomerQuery name(Filter<String> name) {
        return this.name(name, null);
    }

    public CustomerQuery name(String lastName, String firstName) {
        return this.name((Filter<String>)(lastName != null ? Filter.equal((Object)lastName) : null), (Filter<String>)(firstName != null ? Filter.equal((Object)firstName) : null));
    }

    public CustomerQuery name(Filter<String> lastName, Filter<String> firstName) {
        Filter<String> name = lastName != null ? this.createNameFilter(lastName, firstName) : null;
        return (CustomerQuery)super.name(name);
    }

    public CustomerQuery address(String address, String suburb, String postcode, String state) {
        this.address = AddressFilter.create(address, suburb, postcode, state);
        return this;
    }

    public CustomerQuery address(Filter<String> address, Filter<String> suburb, Filter<String> postcode, Filter<String> state) {
        this.address = AddressFilter.create(address, suburb, postcode, state);
        return this;
    }

    public CustomerQuery email(String email) {
        return this.email((Filter<String>)(email != null ? Filter.equal((Object)email) : null));
    }

    public CustomerQuery email(Filter<String> email) {
        this.email = email;
        return this;
    }

    public CustomerQuery phone(String phone) {
        return this.phone((Filter<String>)(phone != null ? Filter.equal((Object)phone) : null));
    }

    public CustomerQuery phone(Filter<String> phone) {
        this.phone = phone;
        return this;
    }

    @Override
    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<Party> query, Root<Party> from, CriteriaBuilder builder) {
        super.addPredicates(predicates, query, from, builder);
        if (this.address != null) {
            this.addAddressPredicate(this.address, predicates, query, (From<?, Party>)from, builder);
        }
        if (this.email != null) {
            this.addEmailPredicate(this.email, predicates, (From<?, Party>)from, builder);
        }
        if (this.phone != null) {
            this.addPhonePredicate(this.phone, predicates, (From<?, Party>)from, builder);
        }
    }
}

