/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.query;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.From;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.AddressFilter;
import org.openvpms.domain.internal.query.DomainQueryImpl;
import org.openvpms.domain.internal.query.DomainQueryState;
import org.openvpms.domain.query.DomainQuery;
import org.openvpms.domain.query.Filter;

public class PartyQueryImpl<D, T extends Party, Q extends DomainQuery<D, Q>>
extends DomainQueryImpl<D, T, Q> {
    protected PartyQueryImpl(Class<D> domainTpe, Class<T> type, ArchetypeService service, DomainService domainService) {
        super(domainTpe, type, service, domainService);
    }

    protected PartyQueryImpl(String archetype, Class<D> domainTpe, Class<T> type, ArchetypeService service, DomainService domainService) {
        super(archetype, domainTpe, type, service, domainService);
    }

    protected PartyQueryImpl(DomainQueryState<D, T> state) {
        super(state);
    }

    protected Filter<String> createNameFilter(Filter<String> lastName, Filter<String> firstName) {
        Filter result;
        if (lastName == null) {
            throw new IllegalArgumentException("Argument 'lastName' cannot be null");
        }
        if (lastName.getOperator() != Filter.Operator.EQUAL && lastName.getOperator() != Filter.Operator.LIKE) {
            throw new IllegalArgumentException("Operator must be EQUAL or LIKE");
        }
        if (firstName != null && firstName.getOperator() != lastName.getOperator()) {
            throw new IllegalArgumentException("Both 'firstName' and 'lastName' must have the same operator");
        }
        String name = (String)lastName.getValue();
        name = name + ",";
        if (firstName != null) {
            name = name + (String)firstName.getValue();
        }
        if (lastName.getOperator() == Filter.Operator.EQUAL) {
            result = firstName != null ? Filter.equal((Object)name) : Filter.like((String)(name + "%"));
        } else {
            if (firstName == null) {
                name = name + "%";
            }
            result = Filter.like((String)name);
        }
        return result;
    }

    protected void addAddressPredicate(AddressFilter filter, List<Predicate> predicates, CriteriaQuery<Party> query, From<?, Party> from, CriteriaBuilder builder) {
        Join addresses = from.join("contacts", "contact.location").alias("addressContact");
        if (filter.getAddress() != null) {
            predicates.add(this.createPredicate(addresses.get("address"), filter.getAddress(), builder));
        }
        if (filter.getSuburb() != null) {
            Root suburbLookups = query.from(Lookup.class, new String[]{"lookup.suburb"}).alias("suburb");
            predicates.add(builder.equal((Expression)addresses.get("suburb"), (Expression)suburbLookups.get("code")));
            predicates.add(this.createPredicate(suburbLookups.get("name"), filter.getSuburb(), builder));
        }
        if (filter.getPostcode() != null) {
            predicates.add(this.createPredicate(addresses.get("postcode"), filter.getPostcode(), builder));
        }
        if (filter.getState() != null) {
            Root stateLookups = query.from(Lookup.class, new String[]{"lookup.state"}).alias("state");
            predicates.add(builder.equal((Expression)addresses.get("state"), (Expression)stateLookups.get("code")));
            predicates.add(this.createPredicate(stateLookups.get("name"), filter.getState(), builder));
        }
    }

    protected void addEmailPredicate(Filter<String> filter, List<Predicate> predicates, From<?, Party> from, CriteriaBuilder builder) {
        Join emails = from.join("contacts", "contact.email");
        predicates.add(this.createPredicate(emails.get("emailAddress"), filter, builder));
    }

    protected void addPhonePredicate(Filter<String> filter, List<Predicate> predicates, From<?, Party> from, CriteriaBuilder builder) {
        Join phones = from.join("contacts", "contact.phoneNumber");
        predicates.add(this.createPredicate(phones.get("telephoneNumber"), filter, builder));
    }
}

