/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.query.Filter;

public class DomainQueryState<D, T> {
    private final Class<D> domainType;
    private final Class<T> type;
    private final ArchetypeService service;
    private final DomainService domainService;
    private Set<Order> order = new LinkedHashSet<Order>();
    private List<String> archetypes;
    private Filter<Long> id;
    private Filter<Boolean> active;
    private Filter<String> name;
    private int firstResult;
    private Integer pageSize;
    private Integer maxResults;

    public DomainQueryState(Class<D> domainType, Class<T> type, ArchetypeService service, DomainService domainService) {
        this.domainType = domainType;
        this.type = type;
        this.service = service;
        this.domainService = domainService;
    }

    public <D2 extends IMObject> DomainQueryState<D2, T> newState(Class<D2> domainType) {
        DomainQueryState<D2, T> result = new DomainQueryState<D2, T>(domainType, this.type, this.service, this.domainService);
        this.populate(result);
        return result;
    }

    public Class<D> getDomainType() {
        return this.domainType;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ArchetypeService getService() {
        return this.service;
    }

    public DomainService getDomainService() {
        return this.domainService;
    }

    public List<String> getArchetypes() {
        return this.archetypes;
    }

    public void setArchetypes(String ... archetypes) {
        this.setArchetypes(Arrays.asList(archetypes));
    }

    public void setArchetypes(List<String> archetypes) {
        this.archetypes = archetypes;
    }

    public Filter<Long> getId() {
        return this.id;
    }

    public void setId(Filter<Long> id) {
        this.id = id;
    }

    public Filter<Boolean> getActive() {
        return this.active;
    }

    public void setActive(Filter<Boolean> active) {
        this.active = active;
    }

    public Filter<String> getName() {
        return this.name;
    }

    public void setName(Filter<String> name) {
        this.name = name;
    }

    public void setOrderById(boolean ascending) {
        this.order.add(new Order(Order.Node.ID, ascending));
    }

    public void setOrderByName(boolean ascending) {
        this.order.add(new Order(Order.Node.NAME, ascending));
    }

    public Collection<Order> getOrder() {
        return this.order;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    protected void populate(DomainQueryState<?, ?> state) {
        state.setArchetypes(this.archetypes);
        state.setId(this.id);
        state.setActive(this.active);
        state.setName(this.name);
        state.order = new LinkedHashSet<Order>(this.order);
        state.setFirstResult(this.firstResult);
        state.setPageSize(this.pageSize);
        state.setMaxResults(this.maxResults);
    }

    public static class Order {
        private final Node node;
        private final boolean ascending;

        public Order(Node node, boolean ascending) {
            this.node = node;
            this.ascending = ascending;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public boolean equals(Object other) {
            return other instanceof Order && this.node == ((Order)other).node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public static enum Node {
            ID,
            NAME;

        }
    }
}

