/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.DomainQueryState;
import org.openvpms.domain.query.Active;
import org.openvpms.domain.query.DomainQuery;
import org.openvpms.domain.query.Filter;

public abstract class DomainQueryImpl<D, T extends IMObject, Q extends DomainQuery<D, Q>>
implements DomainQuery<D, Q> {
    private final DomainQueryState<D, T> state;
    private static final int DEFAULT_PAGE_SIZE = 25;
    private static final int MAX_PAGE_SIZE = 500;

    protected DomainQueryImpl(Class<D> domainTpe, Class<T> type, ArchetypeService service, DomainService domainService) {
        this(null, domainTpe, type, service, domainService);
    }

    protected DomainQueryImpl(String archetype, Class<D> domainTpe, Class<T> type, ArchetypeService service, DomainService domainService) {
        this.state = new DomainQueryState<D, T>(domainTpe, type, service, domainService);
        if (archetype != null) {
            this.archetypes(archetype);
        }
        this.pageSize(25);
    }

    protected DomainQueryImpl(DomainQueryState<D, T> state) {
        this.state = state;
    }

    public Q id(long id) {
        this.state.setId((Filter<Long>)Filter.equal((Object)id));
        return this.getThis();
    }

    public Q id(Filter<Long> id) {
        this.state.setId(id);
        return this.getThis();
    }

    public Q name(String name) {
        return this.name((Filter<String>)(name != null ? Filter.equal((Object)name) : null));
    }

    public Q name(Filter<String> name) {
        this.state.setName(name);
        return this.getThis();
    }

    public Q active() {
        return this.active(Active.ACTIVE);
    }

    public Q inactive() {
        return this.active(Active.INACTIVE);
    }

    public Q active(Active active) {
        this.state.setActive(this.getActiveFilter(active));
        return this.getThis();
    }

    public Q orderById() {
        return this.orderById(true);
    }

    public Q orderById(boolean ascending) {
        this.state.setOrderById(ascending);
        return this.getThis();
    }

    public Q orderByName() {
        return this.orderByName(true);
    }

    public Q orderByName(boolean ascending) {
        this.state.setOrderByName(ascending);
        return this.getThis();
    }

    public Q firstResult(int firstResult) {
        this.state.setFirstResult(firstResult);
        return this.getThis();
    }

    public Q pageSize(int pageSize) {
        this.state.setPageSize(pageSize);
        return this.getThis();
    }

    public Q maxResults(int maxResults) {
        this.state.setMaxResults(maxResults);
        return this.getThis();
    }

    public D findFirst() {
        TypedQuery<T> query = this.createQuery();
        IMObject object = (IMObject)query.getFirstResult();
        return object != null ? (D)this.getDomainObject(object) : null;
    }

    public Iterable<D> query() {
        TypedQuery<T> query = this.createQuery();
        Integer size = this.state.getPageSize();
        Integer maxResults = this.state.getMaxResults();
        if (size == null) {
            size = this.state.getMaxResults();
        }
        if (size == null || size > 500) {
            size = 500;
        }
        int limit = maxResults != null ? maxResults : -1;
        return this.createIterable(query, this.state.getFirstResult(), size, limit);
    }

    protected Q archetypes(String ... archetypes) {
        this.state.setArchetypes(archetypes);
        return this.getThis();
    }

    protected DomainQueryState<D, T> getState() {
        return this.state;
    }

    protected TypedQuery<T> createQuery() {
        List<String> archetypes = this.state.getArchetypes();
        ArchetypeService service = this.state.getService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.state.getType());
        if (archetypes == null || archetypes.size() == 0) {
            throw new IllegalStateException("No archetypes specified");
        }
        Class<T> type = this.state.getType();
        Root from = query.from(type, archetypes.toArray(new String[0]));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        query.select((Selection)from);
        this.addPredicates(predicates, query, from, builder);
        this.addOrderBy(query, from, builder);
        query.where(predicates);
        return service.createQuery(query);
    }

    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<T> query, Root<T> from, CriteriaBuilder builder) {
        Filter<String> name;
        Filter<Boolean> active;
        Filter<Long> id = this.state.getId();
        if (id != null) {
            this.addPredicate(from.get("id"), id, predicates, builder);
        }
        if ((active = this.state.getActive()) != null) {
            this.addPredicate(from.get("active"), active, predicates, builder);
        }
        if ((name = this.state.getName()) != null) {
            this.addPredicate(from.get("name"), name, predicates, builder);
        }
    }

    protected void addOrderBy(CriteriaQuery<T> query, Root<T> from, CriteriaBuilder builder) {
        boolean id = false;
        ArrayList<Order> clauses = new ArrayList<Order>();
        for (DomainQueryState.Order order : this.state.getOrder()) {
            if (order.getNode() == DomainQueryState.Order.Node.NAME) {
                clauses.add(this.getOrderBy("name", from, order.isAscending(), builder));
                continue;
            }
            clauses.add(this.getOrderBy("id", from, order.isAscending(), builder));
            id = true;
        }
        if (!id) {
            clauses.add(this.getOrderBy("id", from, true, builder));
        }
        query.orderBy(clauses.toArray(new Order[0]));
    }

    protected <X extends Comparable<? super X>> void addPredicate(Path<X> path, Filter<X> filter, List<Predicate> predicates, CriteriaBuilder builder) {
        predicates.add(this.createPredicate(path, filter, builder));
    }

    protected <X extends Comparable<? super X>> Predicate createPredicate(Path<X> path, Filter<X> filter, CriteriaBuilder builder) {
        Predicate result;
        Comparable value = (Comparable)filter.getValue();
        Filter.Operator operator = filter.getOperator();
        if (operator == Filter.Operator.EQUAL) {
            result = value != null ? builder.equal(path, (Object)value) : builder.isNull(path);
        } else if (operator == Filter.Operator.NOT_EQUAL) {
            result = value != null ? builder.notEqual(path, (Object)value) : builder.isNotNull(path);
        } else if (operator == Filter.Operator.LESS_THAN) {
            result = builder.lessThan(path, value);
        } else if (operator == Filter.Operator.LESS_THAN_EQUAL) {
            result = builder.lessThanOrEqualTo(path, value);
        } else if (operator == Filter.Operator.GREATER_THAN) {
            result = builder.greaterThan(path, value);
        } else if (operator == Filter.Operator.GREATER_THAN_EQUAL) {
            result = builder.greaterThanOrEqualTo(path, value);
        } else if (operator == Filter.Operator.LIKE) {
            result = builder.like(path, (String)((Object)value));
        } else {
            throw new IllegalStateException("Unsupported operator=" + operator);
        }
        return result;
    }

    protected Filter<Boolean> getActiveFilter(Active active) {
        Filter result = active == Active.ALL ? null : (active == Active.ACTIVE ? Filter.equal((Object)true) : Filter.equal((Object)false));
        return result;
    }

    protected Q getThis() {
        return (Q)this;
    }

    protected D getDomainObject(T object) {
        Class<D> domainType = this.state.getDomainType();
        D result = domainType == this.state.getType() ? domainType.cast(object) : this.createDomainObject(object);
        return result;
    }

    protected D createDomainObject(T object) {
        return this.state.getDomainService().create(object, this.state.getDomainType());
    }

    private Order getOrderBy(String name, Root<T> from, boolean ascending, CriteriaBuilder builder) {
        Path expression = from.get(name);
        return ascending ? builder.asc((Expression)expression) : builder.desc((Expression)expression);
    }

    private Iterable<D> createIterable(TypedQuery<T> query, int firstResult, int pageSize, int maxResults) {
        return () -> this.createIterator(query, firstResult, pageSize, maxResults);
    }

    private Iterator<D> createIterator(TypedQuery<T> query, int firstResult, int pageSize, int maxResults) {
        Object iterator = new TypedQueryIterator(query, firstResult, pageSize);
        if (maxResults >= 0) {
            iterator = new LimitedIterator(iterator, maxResults);
        }
        return new DomainIterator(iterator);
    }

    private static class LimitedIterator<X>
    implements Iterator<X> {
        private final Iterator<X> iterator;
        private final int maxResults;
        private int count;

        public LimitedIterator(Iterator<X> iterator, int maxResults) {
            this.iterator = iterator;
            this.maxResults = maxResults;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.maxResults && this.iterator.hasNext();
        }

        @Override
        public X next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            X next = this.iterator.next();
            ++this.count;
            return next;
        }
    }

    class DomainIterator
    implements Iterator<D> {
        private final Iterator<T> iterator;

        public DomainIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public D next() {
            IMObject object = (IMObject)this.iterator.next();
            return DomainQueryImpl.this.getDomainObject(object);
        }
    }
}

