/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.product;

import java.math.BigDecimal;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.product.Product;
import org.openvpms.domain.product.TemplateItem;

public class TemplateItemImpl
implements TemplateItem {
    private final Product product;
    private final IMObjectBean bean;

    public TemplateItemImpl(Product product, IMObjectBean relationship) {
        this.product = product;
        this.bean = relationship;
    }

    public Product getProduct() {
        return this.product;
    }

    public BigDecimal getLowQuantity() {
        return this.bean.getBigDecimal("lowQuantity", BigDecimal.ZERO);
    }

    public BigDecimal getHighQuantity() {
        return this.bean.getBigDecimal("highQuantity", BigDecimal.ZERO);
    }

    public BigDecimal getMinWeight() {
        return this.bean.getBigDecimal("minWeight", BigDecimal.ZERO);
    }

    public BigDecimal getMaxWeight() {
        return this.bean.getBigDecimal("maxWeight", BigDecimal.ZERO);
    }

    public WeightUnits getWeightUnits() {
        return WeightUnits.fromString((String)this.bean.getString("weightUnits"), (WeightUnits)WeightUnits.KILOGRAMS);
    }

    public boolean requiresWeight() {
        return this.getMinWeight().compareTo(BigDecimal.ZERO) != 0 || this.getMaxWeight().compareTo(BigDecimal.ZERO) != 0;
    }

    public boolean inWeightRange(Weight weight) {
        return weight.between(this.getMinWeight(), this.getMaxWeight(), this.getWeightUnits());
    }

    public boolean getSkipIfMissing() {
        return this.bean.getBoolean("skipIfMissing");
    }

    public boolean getZeroPrice() {
        return this.bean.getBoolean("zeroPrice");
    }

    public boolean getPrint() {
        return this.bean.getBoolean("print");
    }
}

