/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.practice;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.party.OrganisationImpl;
import org.openvpms.domain.internal.practice.LocationImpl;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.practice.Practice;

public class PracticeImpl
extends OrganisationImpl
implements Practice {
    private final PracticeRules practiceRules;

    public PracticeImpl(Party peer, PracticeRules practiceRules, PartyRules rules, DomainService service) {
        super(peer, rules, service);
        this.practiceRules = practiceRules;
    }

    public List<Location> getLocations() {
        ArrayList<Location> result = new ArrayList<Location>();
        IMObjectBean bean = this.getService().getBean((IMObject)this.getPeer());
        for (Party location : bean.getTargets("locations", Party.class, Policies.active())) {
            result.add(new LocationImpl(location, this.getRules(), this.getService()));
        }
        return result;
    }

    public Location getDefaultLocation() {
        Party location = this.practiceRules.getDefaultLocation((Party)this);
        return location != null ? new LocationImpl(location, this.getRules(), this.getService()) : null;
    }
}

