/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record.builder;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.domain.internal.patient.record.builder.BuildContext;
import org.openvpms.domain.internal.patient.record.builder.ChildRecordBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.record.Note;
import org.openvpms.domain.patient.record.Record;
import org.openvpms.domain.patient.record.builder.NoteBuilder;
import org.openvpms.domain.patient.record.builder.RecordBuilder;

public class NoteBuilderImpl<B extends NoteBuilder<B, P, PB>, P extends Record, PB extends RecordBuilder<P, PB>>
extends ChildRecordBuilderImpl<Note, B, P, PB>
implements NoteBuilder<B, P, PB> {
    private String note;
    private static final String NOTE = "note";
    private static final String DOCUMENT = "document";

    public NoteBuilderImpl(PB parent, PatientServices services) {
        super("act.patientClinicalNote", parent, services);
    }

    public B note(String note) {
        this.note = note;
        return (B)((NoteBuilder)this.getThis());
    }

    @Override
    protected void build(Act object, IMObjectBean bean, BuildContext context) {
        super.build(object, bean, context);
        this.note = StringUtils.trimToNull((String)this.note);
        if (this.note == null) {
            throw new IllegalStateException("Note not set");
        }
        if (this.note.length() <= bean.getMaxLength(NOTE)) {
            bean.setValue(NOTE, (Object)this.note);
            Reference reference = bean.getReference(DOCUMENT);
            if (reference != null) {
                bean.setValue(DOCUMENT, null);
                context.remove(reference);
            }
        } else {
            bean.setValue(NOTE, null);
            org.openvpms.component.model.document.Document document = (org.openvpms.component.model.document.Document)bean.getObject(DOCUMENT, org.openvpms.component.model.document.Document.class);
            if (document == null) {
                document = this.create("document.text", org.openvpms.component.model.document.Document.class);
            }
            TextDocumentHandler handler = new TextDocumentHandler(this.getArchetypeService());
            handler.update((Document)document, this.note);
            bean.setValue(DOCUMENT, (Object)document.getObjectReference());
            context.addChange((IMObject)document);
        }
        context.addChange((IMObject)object);
    }
}

