/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.document.DocumentBuilder;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractDocumentBuilder<T extends DocumentBuilder>
implements DocumentBuilder {
    private final DocumentAct act;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;
    private final DocumentRules rules;
    private String fileName;
    private String mimeType;
    private InputStream content;
    private boolean version = true;
    static final String PROTECTED_DOCUMENT = "protectedDocument";
    static final String VERSIONS = "versions";
    private static final String LAST_MODIFIED = "endTime";

    protected AbstractDocumentBuilder(DocumentAct act, ArchetypeService service, DocumentHandlers handlers, DocumentRules rules) {
        this.act = act;
        this.service = service;
        this.handlers = handlers;
        this.rules = rules;
    }

    public T fileName(String fileName) {
        this.fileName = fileName;
        return this.getThis();
    }

    public T mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this.getThis();
    }

    public T content(InputStream content) {
        this.content = content;
        return this.getThis();
    }

    public T version(boolean version) {
        this.version = version;
        return this.getThis();
    }

    protected T getThis() {
        return (T)this;
    }

    protected Document doBuild(List<IMObject> toSave, List<Reference> toRemove) {
        Document document = this.createDocument();
        this.doBuild(document, toSave, toRemove);
        return document;
    }

    protected void doBuild(Document document, List<IMObject> toSave, List<Reference> toRemove) {
        IMObjectBean bean = this.service.getBean((IMObject)this.act);
        toSave.add((IMObject)document);
        toSave.add((IMObject)this.act);
        Reference existing = this.act.getDocument();
        boolean deleteExisting = false;
        boolean isProtected = this.isProtectedDocument(bean);
        if (existing != null && (isProtected || this.version) && this.supportsVersioning(bean)) {
            DocumentAct versioned = this.rules.createVersion(this.act);
            bean.addTarget(VERSIONS, (IMObject)versioned, "parent");
            toSave.add((IMObject)versioned);
        } else if (existing != null) {
            deleteExisting = true;
        }
        this.act.setDocument(document.getObjectReference());
        this.act.setFileName(document.getName());
        this.act.setMimeType(document.getMimeType());
        this.setLastModified(bean);
        if (isProtected) {
            bean.setValue(PROTECTED_DOCUMENT, null);
        }
        if (deleteExisting) {
            toRemove.add(existing);
        }
    }

    protected Document createDocument() {
        this.fileName = StringUtils.trimToNull((String)this.fileName);
        this.mimeType = StringUtils.trimToNull((String)this.mimeType);
        if (this.fileName == null) {
            throw new IllegalStateException("'fileName' may not be null or empty");
        }
        if (this.mimeType == null) {
            throw new IllegalStateException("'mimeType' may not be null or empty");
        }
        if (this.content == null) {
            throw new IllegalStateException("'content' may not be null");
        }
        DocumentHandler handler = this.handlers.get(this.fileName, this.mimeType);
        return handler.create(this.fileName, this.content, this.mimeType, -1);
    }

    protected Document buildAndCommit() {
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        ArrayList<Reference> toRemove = new ArrayList<Reference>();
        Document document = this.doBuild(toSave, toRemove);
        this.service.save(toSave);
        for (Reference reference : toRemove) {
            IMObject object = this.service.get(reference);
            if (object == null) continue;
            this.service.remove(object);
        }
        return document;
    }

    protected void setLastModified(IMObjectBean bean) {
        if (bean.hasNode(LAST_MODIFIED)) {
            bean.setValue(LAST_MODIFIED, (Object)new Date());
        }
    }

    protected boolean supportsVersioning(IMObjectBean bean) {
        return bean.hasNode(VERSIONS);
    }

    protected boolean isProtectedDocument(IMObjectBean bean) {
        return bean.hasNode(PROTECTED_DOCUMENT) && bean.getBoolean(PROTECTED_DOCUMENT);
    }
}

