/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.party.BeanPartyDecorator;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.patient.MicrochipImpl;
import org.openvpms.domain.internal.patient.alert.AllergyImpl;
import org.openvpms.domain.internal.patient.referral.ReferralsImpl;
import org.openvpms.domain.patient.Microchip;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.alert.Allergies;
import org.openvpms.domain.patient.alert.Allergy;
import org.openvpms.domain.patient.referral.Referrals;

public class PatientImpl
extends BeanPartyDecorator
implements Patient {
    private final PatientRules patientRules;
    private final DomainService domainService;
    private static final String DATE_OF_BIRTH = "dateOfBirth";
    private static final String SPECIES = "species";
    private static final String BREED = "breed";
    private static final String DECEASED = "deceased";
    private static final String DECEASED_DATE = "deceasedDate";
    private static final String COLOUR = "colour";

    public PatientImpl(Party peer, PatientRules patientRules, DomainService service) {
        super(peer, (IMObjectBeanFactory)service);
        this.patientRules = patientRules;
        this.domainService = service;
    }

    public PatientImpl(IMObjectBean bean, PatientRules patientRules, DomainService service) {
        super(bean);
        this.patientRules = patientRules;
        this.domainService = service;
    }

    public String getAge() {
        return this.hasDateOfBirth() ? this.patientRules.getPatientAge(this.getPeer()) : null;
    }

    public String getAge(LocalDate date) {
        return this.hasDateOfBirth() ? this.patientRules.getPatientAge(this.getPeer(), DateRules.toDate((LocalDate)date)) : null;
    }

    public LocalDate getDateOfBirth() {
        Date date = this.getBean().getDate(DATE_OF_BIRTH);
        return DateRules.toLocalDate((Date)date);
    }

    public boolean isDeceased() {
        return this.getBean().getBoolean(DECEASED);
    }

    public LocalDate getDateOfDeath() {
        Date date = this.getBean().getDate(DECEASED_DATE);
        return date != null ? DateRules.toLocalDate((Date)date) : null;
    }

    public String getSpeciesName() {
        Lookup lookup = this.getSpeciesLookup();
        return lookup != null ? lookup.getName() : null;
    }

    public String getSpeciesCode() {
        return this.getBean().getString(SPECIES);
    }

    public Lookup getSpeciesLookup() {
        return this.getBean().getLookup(SPECIES);
    }

    public String getBreedName() {
        Lookup lookup = this.getBreedLookup();
        String result = lookup != null ? lookup.getName() : this.getBean().getString("newBreed");
        return result;
    }

    public String getBreedCode() {
        return this.getBean().getString(BREED);
    }

    public Lookup getBreedLookup() {
        return this.getBean().getLookup(BREED);
    }

    public Patient.Sex getSex() {
        String code = this.getBean().getString("sex");
        return code != null ? Patient.Sex.valueOf((String)code) : Patient.Sex.UNSPECIFIED;
    }

    public boolean isDesexed() {
        return this.getBean().getBoolean("desexed");
    }

    public String getColourName() {
        Lookup lookup = this.getColourLookup();
        return lookup != null ? lookup.getName() : this.getColourCode();
    }

    public String getColourCode() {
        return this.getBean().getString(COLOUR);
    }

    public Lookup getColourLookup() {
        IMObjectBean bean = this.getBean();
        NodeDescriptor node = bean.getNode(COLOUR);
        return node.isLookup() ? bean.getLookup(COLOUR) : null;
    }

    public Microchip getMicrochip() {
        EntityIdentity identity = this.patientRules.getMicrochip(this.getPeer());
        return identity != null ? new MicrochipImpl((Identity)identity) : null;
    }

    public Customer getOwner() {
        Party owner = this.patientRules.getOwner((Party)this);
        return owner != null ? this.domainService.create(owner, Customer.class) : null;
    }

    public Weight getWeight() {
        return this.patientRules.getWeight((Party)this);
    }

    public boolean isAggressive() {
        return this.patientRules.isAggressive((Party)this);
    }

    public Allergies getAllergies() {
        return new AllergiesImpl();
    }

    private boolean hasDateOfBirth() {
        return this.getBean().getDate(DATE_OF_BIRTH) != null;
    }

    public Referrals getReferrals() {
        return new ReferralsImpl(this.getBean(), this.domainService);
    }

    private class AllergiesImpl
    implements Allergies {
        private AllergiesImpl() {
        }

        public Iterable<Allergy> getCurrent() {
            ArrayList<Allergy> result = new ArrayList<Allergy>();
            List allergies = PatientImpl.this.patientRules.getAllergies((Party)PatientImpl.this, new Date());
            for (Act allergy : allergies) {
                result.add(new AllergyImpl(PatientImpl.this.domainService.getBean((IMObject)allergy)));
            }
            return result;
        }
    }
}

