/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.party;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.business.domain.im.party.BeanPartyDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.ContactableParty;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;

public class ContactablePartyImpl
extends BeanPartyDecorator
implements ContactableParty {
    private final PartyRules rules;
    private final DomainService service;

    public ContactablePartyImpl(Party peer, PartyRules rules, DomainService service) {
        super(peer, (IMObjectBeanFactory)service);
        this.rules = rules;
        this.service = service;
    }

    public ContactablePartyImpl(IMObjectBean bean, PartyRules rules, DomainService service) {
        super(bean);
        this.rules = rules;
        this.service = service;
    }

    public Set<Contact> getContacts() {
        HashSet<Contact> result = new HashSet<Contact>();
        for (Contact contact : super.getContacts()) {
            result.add(this.service.create(contact, Contact.class));
        }
        return result;
    }

    public Address getAddress() {
        Contact contact = this.rules.getAddressContact(this.getPeer(), null);
        return contact != null ? this.service.create(contact, Address.class) : null;
    }

    public List<Address> getAddresses() {
        return this.getContacts("contact.location", Address.class);
    }

    public Phone getPhone() {
        Contact contact = this.rules.getTelephoneContact(this.getPeer());
        return contact != null ? this.service.create(contact, Phone.class) : null;
    }

    public List<Phone> getPhones() {
        return this.getContacts("contact.phoneNumber", Phone.class);
    }

    public Email getEmail() {
        Contact contact = this.rules.getEmailContact(this.getPeer());
        return contact != null ? this.service.create(contact, Email.class) : null;
    }

    public List<Email> getEmails() {
        return this.getContacts("contact.email", Email.class);
    }

    protected Address getAddress(String purpose) {
        Contact contact = this.rules.getAddressContact(this.getPeer(), purpose);
        return contact != null ? this.service.create(contact, Address.class) : null;
    }

    protected Phone getPhone(String purpose) {
        Contact contact = this.rules.getTelephoneContact(this.getPeer(), true, purpose);
        return contact != null ? this.service.create(contact, Phone.class) : null;
    }

    protected PartyRules getRules() {
        return this.rules;
    }

    protected DomainService getService() {
        return this.service;
    }

    protected <T extends Contact> List<T> getContacts(String archetype, String purpose, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        List contacts = this.rules.getContacts(this.getPeer(), archetype, true, null, new String[]{purpose});
        for (Contact contact : contacts) {
            result.add(this.service.create(contact, type));
        }
        return result;
    }

    private <T extends Contact> List<T> getContacts(String archetype, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Contact contact : this.getPeer().getContacts()) {
            if (!contact.isA(archetype)) continue;
            result.add(this.service.create(contact, type));
        }
        return Contacts.sort(result);
    }
}

