/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer.transaction;

import java.math.BigDecimal;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.customer.transaction.TransactionItem;
import org.openvpms.domain.internal.factory.DomainService;

public abstract class TransactionItemImpl
implements TransactionItem {
    private final FinancialAct item;
    private final IMObjectBean bean;
    private final DomainService domainService;

    public TransactionItemImpl(FinancialAct item, DomainService domainService) {
        this.item = item;
        this.bean = domainService.getBean((IMObject)item);
        this.domainService = domainService;
    }

    public TransactionItemImpl(IMObjectBean bean, DomainService domainService) {
        this.item = (FinancialAct)bean.getObject(FinancialAct.class);
        this.bean = bean;
        this.domainService = domainService;
    }

    public long getId() {
        return this.item.getId();
    }

    public BigDecimal getTotal() {
        return this.item.getTotal();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransactionItemImpl) {
            return this.item.equals(((TransactionItemImpl)obj).item);
        }
        return false;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    protected FinancialAct getAct() {
        return this.item;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }
}

