/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer.transaction;

import java.math.BigDecimal;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.transaction.Charge;
import org.openvpms.domain.customer.transaction.ChargeItem;
import org.openvpms.domain.internal.customer.transaction.TransactionImpl;
import org.openvpms.domain.internal.factory.DomainService;

public class ChargeImpl<T extends ChargeItem>
extends TransactionImpl<T>
implements Charge<T> {
    private User clinician;

    public ChargeImpl(FinancialAct charge, Class<T> itemType, DomainService domainService) {
        super(charge, itemType, domainService);
    }

    protected ChargeImpl(IMObjectBean bean, Class<T> itemType, DomainService domainService) {
        super(bean, itemType, domainService);
    }

    public User getClinician() {
        if (this.clinician == null) {
            this.clinician = (User)this.getBean().getTarget("clinician", User.class);
        }
        return this.clinician;
    }

    public BigDecimal getDiscount() {
        BigDecimal result = BigDecimal.ZERO;
        for (ChargeItem item : this.getItems()) {
            result = result.add(item.getDiscount());
        }
        return result;
    }

    public BigDecimal getDiscountTax() {
        BigDecimal result = BigDecimal.ZERO;
        for (ChargeItem item : this.getItems()) {
            result = result.add(item.getDiscountTax());
        }
        return result;
    }

    public BigDecimal getTotalTax() {
        return this.getTransaction().getTaxAmount();
    }
}

