/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer;

import java.util.Collection;
import java.util.List;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.CustomerPatients;
import org.openvpms.domain.internal.customer.CustomerPatientsImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.party.ContactablePartyImpl;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.practice.Location;

public class CustomerImpl
extends ContactablePartyImpl
implements Customer {
    private static final String TITLE = "title";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String COMPANY_NAME = "companyName";
    private static final String PATIENTS = "patients";
    private static final String PRACTICE = "practice";

    public CustomerImpl(Party peer, CustomerRules rules, DomainService service) {
        super(peer, (PartyRules)rules, service);
    }

    public CustomerImpl(IMObjectBean bean, PartyRules rules, DomainService service) {
        super(bean, rules, service);
    }

    public Lookup getTitleLookup() {
        return this.getBean().getLookup(TITLE);
    }

    public String getTitle() {
        Lookup lookup = this.getTitleLookup();
        return lookup != null ? lookup.getName() : null;
    }

    @Deprecated
    public String getTitleName() {
        return this.getTitle();
    }

    public String getTitleCode() {
        return this.getBean().getString(TITLE);
    }

    public String getFirstName() {
        return this.getBean().getString(FIRST_NAME);
    }

    public String getLastName() {
        return this.getBean().getString(LAST_NAME);
    }

    public String getFullName() {
        StringBuilder result = new StringBuilder();
        String title = this.getTitle();
        String firstName = this.getFirstName();
        String lastName = this.getLastName();
        if (title != null) {
            result.append(title);
        }
        if (firstName != null) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(firstName);
        }
        if (lastName != null) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(lastName);
        }
        return result.length() != 0 ? result.toString() : null;
    }

    public String getCompanyName() {
        return this.getBean().hasNode(COMPANY_NAME) ? this.getBean().getString(COMPANY_NAME) : null;
    }

    @Override
    public Address getAddress() {
        return this.getAddress("BILLING");
    }

    public Address getMailingAddress() {
        return this.getAddress("CORRESPONDENCE");
    }

    public Phone getWorkPhone() {
        return this.getPhone("WORK");
    }

    public Phone getHomePhone() {
        Phone phone = this.getPhone("HOME");
        if (phone == null) {
            Contact contact;
            DomainService service = this.getService();
            List contacts = Contacts.sort((Collection)this.getPeer().getContacts());
            if (!contacts.isEmpty() && (contact = Contacts.find((Collection)contacts, (ContactMatcher)new ContactMatcher("contact.phoneNumber", service){

                public boolean matches(Contact contact) {
                    boolean result = false;
                    if (super.matches(contact) && PurposeMatcher.hasNoContactPurpose((Contact)contact)) {
                        if (this.isPreferred(contact)) {
                            this.setMatch(1, contact);
                            result = true;
                        } else {
                            this.setMatch(2, contact);
                        }
                    }
                    return result;
                }
            })) != null) {
                phone = service.create(contact, Phone.class);
            }
        }
        return phone;
    }

    public Phone getMobilePhone() {
        return this.getPhone("MOBILE");
    }

    public CustomerPatients getPatients() {
        List patients = this.getBean().getValues(PATIENTS, EntityRelationship.class);
        return this.getService().createRelated(patients, CustomerPatientsImpl.class);
    }

    public Location getPractice() {
        Party location = (Party)this.getBean().getTarget(PRACTICE, Party.class);
        return location != null ? this.getService().create(location, Location.class) : null;
    }
}

