/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.test;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.internal.factory.DomainService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDomainObjectTest
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;

    @Test
    public abstract void testEquality();

    @Test
    public abstract void testFactory();

    protected void checkEquality(IMObject object1, IMObject object2, Class<?> domainInterface) {
        Object domain1A = this.domainService.create(object1, domainInterface);
        Object domain1B = this.domainService.create(object1, domainInterface);
        Object domain2 = this.domainService.create(object2, domainInterface);
        Assert.assertEquals((Object)domain1A, (Object)domain1B);
        Assert.assertEquals((long)domain1A.hashCode(), (long)domain1B.hashCode());
        Assert.assertNotEquals((Object)domain1A, (Object)domain2);
        Assert.assertNotEquals((long)domain1A.hashCode(), (long)domain2.hashCode());
    }

    protected <T, I extends T> void checkFactory(IMObject object, Class<T> domainInterface, Class<I> domainImpl) {
        Object object1 = this.domainService.create(object, domainInterface);
        Assert.assertTrue((boolean)domainInterface.isAssignableFrom(object1.getClass()));
        Assert.assertEquals(domainImpl, object1.getClass());
        IMObjectBean bean = this.getBean(object);
        Object object2 = this.domainService.create(bean, domainInterface);
        Assert.assertTrue((boolean)domainInterface.isAssignableFrom(object2.getClass()));
        Assert.assertEquals(domainImpl, object2.getClass());
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }
}

