/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.supplier;

import java.time.OffsetDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.supplier.ReferralVetImpl;
import org.openvpms.domain.internal.test.AbstractDomainObjectTest;
import org.openvpms.domain.supplier.ReferralVet;
import org.springframework.beans.factory.annotation.Autowired;

public class ReferralVetImplTestCase
extends AbstractDomainObjectTest {
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Override
    public void testEquality() {
        Party party1 = (Party)this.supplierFactory.newVet().build(false);
        Party party2 = (Party)this.supplierFactory.newVet().build(false);
        this.checkEquality((IMObject)party1, (IMObject)party2, ReferralVet.class);
    }

    @Override
    public void testFactory() {
        Party party = (Party)this.supplierFactory.newVet().build(false);
        this.checkFactory((IMObject)party, ReferralVet.class, ReferralVetImpl.class);
    }

    @Test
    public void testAccessors() {
        Party practice1 = this.supplierFactory.createVetPractice();
        Party practice2 = this.supplierFactory.createVetPractice();
        Party party = (Party)this.supplierFactory.newVet().title("DR").firstName("J").lastName("Smith").addPractice(practice1, DateRules.getYesterday()).addPractice(practice2, DateRules.getToday()).build();
        ReferralVet vet = (ReferralVet)this.getDomainService().create((IMObject)party, ReferralVet.class);
        Assert.assertTrue((boolean)(vet instanceof ReferralVetImpl));
        Assert.assertEquals((Object)"Dr", (Object)vet.getTitle());
        Assert.assertEquals((Object)"J", (Object)vet.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)vet.getLastName());
        Assert.assertEquals((Object)practice2, (Object)vet.getPractice());
        Assert.assertEquals((Object)practice1, (Object)vet.getPractice(OffsetDateTime.now().minusDays(1L)));
    }
}

