/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.user;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.user.UsersImpl;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.user.UserQuery;
import org.openvpms.domain.service.user.Users;
import org.openvpms.domain.user.Employee;
import org.springframework.beans.factory.annotation.Autowired;

public class UsersImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    TestUserFactory userFactory;
    @Autowired
    private DomainService domainObjectService;
    private Users users;

    @Before
    public void setUp() {
        this.users = new UsersImpl((ArchetypeService)this.getArchetypeService(), this.domainObjectService);
    }

    @Test
    public void testGetUser() {
        Assert.assertNull((Object)this.users.getUser(0L));
        User user1 = this.userFactory.createUser();
        User result1 = this.users.getUser(user1.getId());
        Assert.assertEquals((Object)user1, (Object)result1);
        Assert.assertFalse((boolean)(result1 instanceof Employee));
        User user2 = this.userFactory.createUser("J", "Bloggs");
        User result2 = this.users.getUser(user2.getId());
        Assert.assertEquals((Object)user2, (Object)result2);
        Assert.assertTrue((boolean)(result2 instanceof Employee));
        user1.setActive(false);
        this.save((IMObject)user1);
        Assert.assertEquals((Object)user1, (Object)this.users.getUser(user1.getId()));
    }

    @Test
    public void testGetUserByUsername() {
        Assert.assertNull((Object)this.users.getUser(0L));
        User user1 = this.userFactory.createUser();
        User result1 = this.users.getUser(user1.getUsername());
        Assert.assertEquals((Object)user1, (Object)result1);
        Assert.assertFalse((boolean)(result1 instanceof Employee));
        User user2 = this.userFactory.createUser("J", "Bloggs");
        User result2 = this.users.getUser(user2.getUsername());
        Assert.assertEquals((Object)user2, (Object)result2);
        Assert.assertTrue((boolean)(result2 instanceof Employee));
        user1.setActive(false);
        this.save((IMObject)user1);
        Assert.assertEquals((Object)user1, (Object)this.users.getUser(user1.getUsername()));
    }

    @Test
    public void testQueryByName() {
        User user1 = this.userFactory.createUser("A", TestHelper.randomName((String)"XUserA"));
        User user2 = this.userFactory.createUser("B", TestHelper.randomName((String)"XUserB"));
        User user3 = this.userFactory.createUser("C", TestHelper.randomName((String)"YUserC"));
        Assert.assertEquals((Object)user1, (Object)((UserQuery)this.users.getQuery().name(user1.getName())).findFirst());
        Assert.assertEquals((Object)user1, (Object)((UserQuery)this.users.getQuery().name(Filter.equal((Object)user1.getName()))).findFirst());
        Assert.assertNotEquals((Object)user1, (Object)((UserQuery)this.users.getQuery().name(Filter.notEqual((Object)user1.getName()))).findFirst());
        List matches = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().name(Filter.like((String)"%XUser%"))).query());
        Assert.assertTrue((boolean)matches.contains(user1));
        Assert.assertTrue((boolean)matches.contains(user2));
        TestHelper.assertExcluded((List)matches, (Object[])new User[]{user3});
    }

    @Test
    public void testQueryActive() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        User user3 = (User)((TestUserBuilder)this.userFactory.newUser().active(false)).build();
        List matches1 = IterableUtils.toList((Iterable)this.users.getQuery().query());
        TestHelper.assertIncluded((List)matches1, (Object[])new User[]{user1, user2, user3});
        List matches2 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().active()).query());
        TestHelper.assertIncluded((List)matches2, (Object[])new User[]{user1, user2});
        TestHelper.assertExcluded((List)matches2, (Object[])new User[]{user3});
        List matches3 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().inactive()).query());
        TestHelper.assertIncluded((List)matches3, (Object[])new User[]{user3});
        TestHelper.assertExcluded((List)matches3, (Object[])new User[]{user1, user2});
    }

    @Test
    public void testQueryByUsername() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        User user3 = this.userFactory.createUser();
        List matches1 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().username(user1.getUsername())).query());
        TestHelper.assertIncluded((List)matches1, (Object[])new User[]{user1});
        TestHelper.assertExcluded((List)matches1, (Object[])new User[]{user2, user3});
        user1.setActive(false);
        this.save((IMObject)user1);
        List matches2 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().username(user1.getUsername())).query());
        TestHelper.assertIncluded((List)matches2, (Object[])new User[]{user1});
        TestHelper.assertExcluded((List)matches2, (Object[])new User[]{user2, user3});
        List matches3 = IterableUtils.toList((Iterable)((UserQuery)((UserQuery)this.users.getQuery().username(user1.getUsername())).active()).query());
        TestHelper.assertExcluded((List)matches3, (Object[])new User[]{user1, user2, user3});
        List matches4 = IterableUtils.toList((Iterable)((UserQuery)((UserQuery)this.users.getQuery().username(user1.getUsername())).inactive()).query());
        TestHelper.assertIncluded((List)matches1, (Object[])new User[]{user1});
        TestHelper.assertExcluded((List)matches4, (Object[])new User[]{user2, user3});
    }

    @Test
    public void testQueryByEmployee() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser("J", "Bloggs");
        User user3 = this.userFactory.createUser("A", "Smith");
        ArrayList matches = new ArrayList(IterableUtils.toList((Iterable)this.users.getQuery().employees().query()));
        TestHelper.assertIncluded(matches, (Object[])new User[]{user2, user3});
        TestHelper.assertExcluded(matches, (Object[])new User[]{user1});
    }

    @Test
    public void testQueryByClinician() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createClinician();
        User user3 = this.userFactory.createClinician();
        List matches1 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().clinicians()).query());
        TestHelper.assertIncluded((List)matches1, (Object[])new User[]{user2, user3});
        TestHelper.assertExcluded((List)matches1, (Object[])new User[]{user1});
        user2.setActive(false);
        this.save((IMObject)user2);
        List matches2 = IterableUtils.toList((Iterable)((UserQuery)this.users.getQuery().clinicians()).query());
        TestHelper.assertIncluded((List)matches2, (Object[])new User[]{user2, user3});
        TestHelper.assertExcluded((List)matches2, (Object[])new User[]{user1});
        List matches3 = IterableUtils.toList((Iterable)((UserQuery)((UserQuery)this.users.getQuery().clinicians()).active()).query());
        TestHelper.assertIncluded((List)matches3, (Object[])new User[]{user3});
        TestHelper.assertExcluded((List)matches3, (Object[])new User[]{user1, user2});
        List matches4 = IterableUtils.toList((Iterable)((UserQuery)((UserQuery)this.users.getQuery().clinicians()).inactive()).query());
        TestHelper.assertIncluded((List)matches4, (Object[])new User[]{user2});
        TestHelper.assertExcluded((List)matches4, (Object[])new User[]{user1, user3});
    }
}

