/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.practice;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.practice.PracticeServiceImpl;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.practice.Practice;
import org.springframework.beans.factory.annotation.Autowired;

public class PracticeServiceImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeService service;
    @Autowired
    private DomainService domainService;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testGetPractice() {
        Party party = (Party)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Practice A")).build();
        PracticeServiceImpl practiceService = new PracticeServiceImpl(this.service, this.domainService);
        Practice practice1 = practiceService.getPractice();
        Assert.assertNotNull((Object)practice1);
        Assert.assertEquals((Object)party, (Object)practice1);
        practice1.setName("Practice B");
        Assert.assertNotEquals((Object)party.getName(), (Object)practice1.getName());
        Practice practice2 = practiceService.getPractice();
        Assert.assertEquals((Object)party, (Object)practice2);
        Assert.assertNotSame((Object)practice1, (Object)practice2);
        Assert.assertNotEquals((Object)practice1.getName(), (Object)practice2.getName());
    }

    @Test
    public void testGetLocations() {
        Party party = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Location A")).build();
        this.practiceFactory.newPractice().locations(new Party[]{party}).build();
        PracticeServiceImpl practiceService = new PracticeServiceImpl(this.service, this.domainService);
        List locations1 = practiceService.getLocations();
        Assert.assertEquals((long)1L, (long)locations1.size());
        Location location1 = (Location)locations1.get(0);
        location1.setName("Location B");
        Assert.assertNotEquals((Object)party.getName(), (Object)location1.getName());
        List locations2 = practiceService.getLocations();
        Assert.assertEquals((long)1L, (long)locations2.size());
        Location location2 = (Location)locations2.get(0);
        Assert.assertNotEquals((Object)location1.getName(), (Object)location2.getName());
    }
}

