/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.practice;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.practice.PracticeImpl;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.practice.Practice;
import org.springframework.beans.factory.annotation.Autowired;

public class PracticeImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private DomainService domainService;

    @Test
    public void testFactory() {
        Party party = (Party)this.practiceFactory.newPractice().build(false);
        Practice practice = (Practice)this.domainService.create((IMObject)party, Practice.class);
        Assert.assertTrue((boolean)(practice instanceof PracticeImpl));
    }

    @Test
    public void testAccessors() {
        Party location1Party = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Location 1")).build();
        Party location2Party = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Location 2")).build();
        Party party = (Party)((TestPracticeBuilder)((TestPracticeBuilder)((TestPracticeBuilder)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Vets R Us")).locations(new Party[]{location1Party, location2Party}).addAddress("101 Broadwater Ave", "CAPE_WOOLAMAI", "VIC", "1111", new String[0])).addPhone("123456", new String[0])).addEmail("foo@bar.com", new String[0])).build(false);
        Practice practice = (Practice)this.domainService.create((IMObject)party, Practice.class);
        Assert.assertEquals((Object)"Vets R Us", (Object)practice.getName());
        Address address = practice.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"101 Broadwater Ave", (Object)address.getAddress());
        Assert.assertEquals((Object)"Cape Woolamai", (Object)address.getSuburbName());
        Assert.assertEquals((Object)"VIC", (Object)address.getStateCode());
        Phone phone = practice.getPhone();
        Assert.assertNotNull((Object)phone);
        Assert.assertEquals((Object)"123456", (Object)phone.getPhoneNumber());
        Email email = practice.getEmail();
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"foo@bar.com", (Object)email.getEmailAddress());
        List locations = practice.getLocations();
        Assert.assertEquals((long)2L, (long)locations.size());
    }
}

