/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.bean.Order;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.CustomerPatients;
import org.openvpms.domain.internal.customer.CustomerImpl;
import org.openvpms.domain.internal.test.AbstractDomainObjectTest;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.patient.Patient;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerImplTestCase
extends AbstractDomainObjectTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Override
    public void testEquality() {
        Party party1 = (Party)this.customerFactory.newCustomer().build(false);
        Party party2 = (Party)this.customerFactory.newCustomer().build(false);
        this.checkEquality((IMObject)party1, (IMObject)party2, Customer.class);
    }

    @Override
    @Test
    public void testFactory() {
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        this.checkFactory((IMObject)party, Customer.class, CustomerImpl.class);
    }

    @Test
    public void testAccessors() {
        Party party = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MS").firstName("J").lastName("Smith").companyName("Smith Co").addAddress("31 Foo St", "SALE", "VIC", "3000", new String[]{"BILLING"})).addPhone("91234567", new String[]{"HOME"})).addPhone("93334444", new String[]{"WORK"})).addMobilePhone("41234567")).addEmail("jsmith@foo.com", new String[0])).build();
        Party patient1 = (Party)((TestPatientBuilder)((TestPatientBuilder)this.patientFactory.newPatient().owner(party).name("Spot")).active(false)).build();
        Party patient2 = (Party)((TestPatientBuilder)this.patientFactory.newPatient().owner(party).name("Fido")).build();
        Customer customer = (Customer)this.getDomainService().create((IMObject)party, Customer.class);
        Assert.assertTrue((boolean)(customer instanceof CustomerImpl));
        Assert.assertEquals((Object)"J", (Object)customer.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)customer.getLastName());
        Assert.assertEquals((Object)"Ms J Smith", (Object)customer.getFullName());
        Assert.assertEquals((Object)"Smith Co", (Object)customer.getCompanyName());
        Address address = customer.getAddress();
        Address mailing = customer.getMailingAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)address, (Object)mailing);
        Assert.assertEquals((Object)"31 Foo St", (Object)address.getAddress());
        Assert.assertEquals((Object)"SALE", (Object)address.getSuburbCode());
        Assert.assertEquals((Object)"VIC", (Object)address.getStateCode());
        Assert.assertEquals((Object)"3000", (Object)address.getPostcode());
        this.checkPhone(customer.getHomePhone(), "91234567", false);
        this.checkPhone(customer.getWorkPhone(), "93334444", false);
        this.checkPhone(customer.getMobilePhone(), "41234567", true);
        Assert.assertEquals((Object)"jsmith@foo.com", (Object)customer.getEmail().getEmailAddress());
        Order order = Order.ascending((String)"name");
        CustomerPatients patients = customer.getPatients();
        this.checkPatients(patients.getObjects(), false, patient1, patient2);
        this.checkPatients(((CustomerPatients)patients.active()).getObjects(), false, patient2);
        this.checkPatients(patients.getObjects(0, 10, new Order[]{order}), true, patient2, patient1);
        TestLocationContactBuilder builder = new TestLocationContactBuilder((ArchetypeService)this.getArchetypeService());
        party.addContact(((TestLocationContactBuilder)builder.address("PO Box 1").suburbCode("SALE").stateCode("VIC").postcode("3085").purposes(new String[]{"CORRESPONDENCE"})).build());
        Address mailing2 = customer.getMailingAddress();
        Assert.assertNotNull((Object)mailing);
        Assert.assertNotEquals((Object)mailing2, (Object)customer.getAddress());
        Assert.assertEquals((Object)"PO Box 1", (Object)mailing2.getAddress());
    }

    @Test
    public void testMultiplePhonesWithNoPurpose() {
        Party party = (Party)this.customerFactory.newCustomer().build();
        Customer customer1 = (Customer)this.getDomainService().create((IMObject)party, Customer.class);
        Assert.assertNull((Object)customer1.getHomePhone());
        Assert.assertNull((Object)customer1.getWorkPhone());
        ((TestCustomerBuilder)((TestPhoneContactBuilder)this.customerFactory.updateCustomer(party).newPhone().phone("1").preferred(false)).add()).build();
        Customer customer2 = (Customer)this.getDomainService().create((IMObject)party, Customer.class);
        Assert.assertEquals((Object)"1", (Object)customer2.getHomePhone().getPhoneNumber());
        Assert.assertNull((Object)customer2.getWorkPhone());
        ((TestCustomerBuilder)((TestPhoneContactBuilder)this.customerFactory.updateCustomer(party).newPhone().phone("2").preferred(false)).add()).build();
        Customer customer3 = (Customer)this.getDomainService().create((IMObject)party, Customer.class);
        Assert.assertEquals((Object)"1", (Object)customer3.getHomePhone().getPhoneNumber());
        Assert.assertNull((Object)customer3.getWorkPhone());
        ((TestCustomerBuilder)((TestPhoneContactBuilder)this.customerFactory.updateCustomer(party).newPhone().phone("3").preferred(true)).add()).build();
        Customer customer4 = (Customer)this.getDomainService().create((IMObject)party, Customer.class);
        Assert.assertEquals((Object)"3", (Object)customer4.getHomePhone().getPhoneNumber());
        Assert.assertNull((Object)customer4.getWorkPhone());
    }

    private void checkPatients(Iterable<Patient> actual, boolean ordered, Party ... expected) {
        List patients = IterableUtils.toList(actual);
        List<Party> list = Arrays.asList(expected);
        if (ordered) {
            Assert.assertEquals(list, (Object)patients);
        } else {
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(list, (Collection)patients));
        }
    }

    private void checkPhone(Phone phone, String number, boolean mobile) {
        Assert.assertNotNull((Object)phone);
        Assert.assertEquals((Object)number, (Object)phone.getPhoneNumber());
        Assert.assertEquals((Object)mobile, (Object)phone.isMobile());
        Assert.assertFalse((boolean)phone.isFax());
    }
}

