/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.user;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.DomainQueryImpl;
import org.openvpms.domain.internal.query.DomainQueryState;
import org.openvpms.domain.internal.service.user.EmployeeQueryImpl;
import org.openvpms.domain.internal.service.user.UserFactory;
import org.openvpms.domain.internal.service.user.UserQueryState;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.user.AbstractUserQuery;
import org.openvpms.domain.service.user.EmployeeQuery;
import org.openvpms.domain.user.Employee;

class AbstractUserQueryImpl<D extends User, Q extends AbstractUserQuery<D, Q>>
extends DomainQueryImpl<D, User, Q>
implements AbstractUserQuery<D, Q> {
    public AbstractUserQueryImpl(Class<D> domainType, ArchetypeService service, DomainService domainService) {
        super(new UserQueryState<D>(domainType, service, domainService));
    }

    protected AbstractUserQueryImpl(UserQueryState<D> state) {
        super(state);
    }

    public Q username(String username) {
        ((UserQueryState)this.getState()).setUsername((Filter<String>)Filter.equal((Object)username));
        return (Q)((AbstractUserQuery)this.getThis());
    }

    public EmployeeQuery employees() {
        UserQueryState state = (UserQueryState)((UserQueryState)this.getState()).newState(Employee.class);
        return new EmployeeQueryImpl(state);
    }

    public Q clinicians() {
        ((UserQueryState)this.getState()).setClinicians(true);
        return (Q)((AbstractUserQuery)this.getThis());
    }

    protected UserQueryState<D> getState() {
        return (UserQueryState)super.getState();
    }

    @Override
    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<User> query, Root<User> from, CriteriaBuilder builder) {
        super.addPredicates(predicates, query, from, builder);
        DomainQueryState state = this.getState();
        if (((UserQueryState)state).getUsername() != null) {
            this.addPredicate(from.get("username"), ((UserQueryState)state).getUsername(), predicates, builder);
        }
        if (((UserQueryState)state).getEmployees()) {
            predicates.add(builder.isNotNull((Expression)from.get("firstName")));
            predicates.add(builder.isNotNull((Expression)from.get("lastName")));
        }
        if (((UserQueryState)state).getClinicians()) {
            Join userType = from.join("classifications", "lookup.userType");
            userType.on((Expression)builder.equal((Expression)userType.get("code"), (Object)"CLINICIAN"));
        }
    }

    @Override
    protected D getDomainObject(User object) {
        return (D)UserFactory.create(object, this.getState().getDomainService());
    }
}

