/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.practice;

import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.practice.Practice;

public class PracticeServiceImpl
implements org.openvpms.domain.service.practice.PracticeService {
    private final PracticeService practiceService;
    private final DomainService domainService;

    public PracticeServiceImpl(PracticeService practiceService, DomainService domainService) {
        this.practiceService = practiceService;
        this.domainService = domainService;
    }

    public Practice getPractice() {
        return this.getPractice(true);
    }

    public List<Location> getLocations() {
        Practice practice = this.getPractice(false);
        return practice != null ? practice.getLocations() : Collections.emptyList();
    }

    public Location getLocation(long id) {
        Policy policy;
        IMObjectBean bean;
        Party location;
        Location result = null;
        Party practice = this.practiceService.getPractice();
        if (practice != null && (location = (Party)(bean = this.domainService.getBean((IMObject)practice)).getTarget("locations", Party.class, policy = Policies.any(relationship -> relationship.getTarget().getId() == id))) != null) {
            result = this.domainService.create(location, Location.class);
        }
        return result;
    }

    private Practice getPractice(boolean copy) {
        Practice result = null;
        Party practice = this.practiceService.getPractice();
        if (practice != null) {
            result = copy ? (Practice)this.domainService.get(practice.getObjectReference(), Practice.class) : this.domainService.create(practice, Practice.class);
        }
        return result;
    }
}

