/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.From;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.AddressFilter;
import org.openvpms.domain.internal.query.PartyQueryImpl;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.query.Active;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.patient.PatientQuery;

public class PatientQueryImpl
extends PartyQueryImpl<Patient, Party, PatientQuery>
implements PatientQuery {
    private Filter<String> microchip;
    private Long ownerId;
    private Filter<String> ownerName;
    private Filter<Boolean> activeOwner;
    private AddressFilter address;
    private Filter<String> email;
    private Filter<String> phone;

    public PatientQueryImpl(ArchetypeService service, DomainService domainService) {
        super("party.patientpet", Patient.class, Party.class, service, domainService);
    }

    public PatientQuery microchip(String microchip) {
        return this.microchip((Filter<String>)(microchip != null ? Filter.equal((Object)microchip) : null));
    }

    public PatientQuery microchip(Filter<String> microchip) {
        this.microchip = microchip;
        return this;
    }

    public PatientQuery owner(Customer owner) {
        if (owner != null) {
            this.owner(owner.getId());
        } else {
            this.ownerId = null;
        }
        return this;
    }

    public PatientQuery owner(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public PatientQuery ownerName(String lastName) {
        return this.ownerName(lastName, null);
    }

    public PatientQuery ownerName(String lastName, String firstName) {
        return this.ownerName((Filter<String>)(lastName != null ? Filter.equal((Object)lastName) : null), (Filter<String>)(firstName != null ? Filter.equal((Object)firstName) : null));
    }

    public PatientQuery ownerName(Filter<String> lastName) {
        return this.ownerName(lastName, null);
    }

    public PatientQuery ownerName(Filter<String> lastName, Filter<String> firstName) {
        this.ownerName = lastName != null ? this.createNameFilter(lastName, firstName) : null;
        return this;
    }

    public PatientQuery activeOwner() {
        return this.activeOwner(Active.ACTIVE);
    }

    public PatientQuery inactiveOwner() {
        return this.activeOwner(Active.INACTIVE);
    }

    public PatientQuery activeOwner(Active active) {
        this.activeOwner = this.getActiveFilter(active);
        return this;
    }

    public PatientQuery ownerAddress(String address, String suburb, String postcode, String state) {
        this.address = AddressFilter.create(address, suburb, postcode, state);
        return this;
    }

    public PatientQuery ownerAddress(Filter<String> address, Filter<String> suburb, Filter<String> postcode, Filter<String> state) {
        this.address = AddressFilter.create(address, suburb, postcode, state);
        return this;
    }

    public PatientQuery ownerEmail(String email) {
        return this.ownerEmail((Filter<String>)(email != null ? Filter.equal((Object)email) : null));
    }

    public PatientQuery ownerEmail(Filter<String> email) {
        this.email = email;
        return this;
    }

    public PatientQuery ownerPhone(String phone) {
        return this.ownerPhone((Filter<String>)(phone != null ? Filter.equal((Object)phone) : null));
    }

    public PatientQuery ownerPhone(Filter<String> phone) {
        this.phone = phone;
        return this;
    }

    @Override
    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<Party> query, Root<Party> from, CriteriaBuilder builder) {
        super.addPredicates(predicates, query, from, builder);
        if (this.microchip != null) {
            Join identity = from.join("identities", "entityIdentity.microchip");
            identity.on((Expression)this.createPredicate(identity.get("identity"), this.microchip, builder));
        }
        if (this.ownerId != null || this.ownerName != null || this.activeOwner != null || this.address != null || this.email != null || this.phone != null) {
            Join customers = from.join("customers", "entityRelationship.patientOwner");
            Join owner = customers.join("source", "party.customerperson");
            owner.alias("owner");
            Date now = new Date();
            predicates.add(builder.lessThanOrEqualTo((Expression)customers.get("activeStartTime"), (Comparable)now));
            predicates.add(builder.or((Expression)builder.greaterThanOrEqualTo((Expression)customers.get("activeEndTime"), (Comparable)now), (Expression)builder.isNull((Expression)customers.get("activeEndTime"))));
            if (this.ownerId != null) {
                predicates.add(this.createPredicate(owner.get("id"), Filter.equal((Object)this.ownerId), builder));
            }
            if (this.ownerName != null) {
                predicates.add(this.createPredicate(owner.get("name"), this.ownerName, builder));
            }
            if (this.activeOwner != null) {
                predicates.add(this.createPredicate(owner.get("active"), this.activeOwner, builder));
            }
            if (this.address != null) {
                this.addAddressPredicate(this.address, predicates, query, (From<?, Party>)owner, builder);
            }
            if (this.email != null) {
                this.addEmailPredicate(this.email, predicates, (From<?, Party>)owner, builder);
            }
            if (this.phone != null) {
                this.addPhonePredicate(this.phone, predicates, (From<?, Party>)owner, builder);
            }
        }
    }
}

