/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.query;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class IdQuery {
    private final ArchetypeService service;

    public IdQuery(ArchetypeService service) {
        this.service = service;
    }

    public <T extends IMObject> T getObject(String archetype, Class<T> type, String idArchetype, String identity) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root<T> from = this.buildIdQuery(archetype, type, idArchetype, identity, builder, query);
        query.select(from);
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return (T)((IMObject)this.service.createQuery(query).getFirstResult());
    }

    public <T extends IMObject> Long getId(String archetype, Class<T> type, String idArchetype, String identity) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<T> from = this.buildIdQuery(archetype, type, idArchetype, identity, builder, query);
        query.select((Selection)from.get("id"));
        return (Long)this.service.createQuery(query).getFirstResult();
    }

    public <T extends IMObject> boolean exists(String archetype, Class<T> type, String idArchetype, String identity) {
        return this.getId(archetype, type, idArchetype, identity) != null;
    }

    private <T extends IMObject> Root<T> buildIdQuery(String archetype, Class<T> type, String idArchetype, String identity, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root from = query.from(type, new String[]{archetype});
        Join identities = from.join("identities", idArchetype);
        query.where((Expression)builder.equal((Expression)identities.get("identity"), (Object)identity));
        return from;
    }
}

